% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.R
\name{zip}
\alias{zip}
\alias{zipr}
\alias{zip_append}
\alias{zipr_append}
\title{Compress Files into 'zip' Archives}
\usage{
zip(
  zipfile,
  files,
  recurse = TRUE,
  compression_level = 9,
  include_directories = TRUE,
  root = ".",
  mode = c("mirror", "cherry-pick")
)

zipr(
  zipfile,
  files,
  recurse = TRUE,
  compression_level = 9,
  include_directories = TRUE,
  root = ".",
  mode = c("cherry-pick", "mirror")
)

zip_append(
  zipfile,
  files,
  recurse = TRUE,
  compression_level = 9,
  include_directories = TRUE,
  root = ".",
  mode = c("mirror", "cherry-pick")
)

zipr_append(
  zipfile,
  files,
  recurse = TRUE,
  compression_level = 9,
  include_directories = TRUE,
  root = ".",
  mode = c("cherry-pick", "mirror")
)
}
\arguments{
\item{zipfile}{The zip file to create. If the file exists, \code{zip}
overwrites it, but \code{zip_append} appends to it.}

\item{files}{List of file to add to the archive. See details below
about absolute and relative path names.}

\item{recurse}{Whether to add the contents of directories recursively.}

\item{compression_level}{A number between 1 and 9. 9 compresses best,
but it also takes the longest.}

\item{include_directories}{Whether to explicitly include directories
in the archive. Including directories might confuse MS Office when
reading docx files, so set this to \code{FALSE} for creating them.}

\item{root}{Change to this working directory before creating the
archive.}

\item{mode}{Selects how files and directories are stored in
the archice. It can be \code{"mirror"} or \code{"cherry-pick"}.
See "Relative Paths" below for details.}
}
\value{
The name of the created zip file, invisibly.
}
\description{
\code{zip()} creates a new zip archive file.

\if{html}{\out{<link rel="stylesheet" type="text/css" href="../doc/assets/extra.css">}}

\if{html}{\out{<script src="../doc/assets/rd.js"></script>}}
}
\details{
\code{zip_append()} appends compressed files to an existing 'zip' file.
\subsection{Relative paths}{

\code{zip()} and \code{zip_append()} can run in two different modes: mirror
mode and cherry picking mode. They handle the specified \code{files}
differently.
\subsection{Mirror mode}{

Mirror mode is for creating the zip archive of a directory structure,
exactly as it is on the disk. The current working directory will
be the root of the archive, and the paths will be fully kept.
zip changes the current directory to \code{root} before creating the
archive.

(Absolute paths are also kept. Note that this might result
non-portable archives: some zip tools do not handle zip archives that
contain absolute file names, or file names that start with \verb{../} or
\verb{./}. zip warns you if this should happen.)

E.g. consider the following directory structure:\preformatted{.
|-- foo
|   |-- bar
|   |   |-- file1
|   |   `-- file2
|   `-- bar2
`-- foo2
    `-- file3
}

Assuming the current working directory is \code{foo}, the following zip
entries are created by \code{zip}:\if{html}{\out{<div class="r">}}\preformatted{setwd("foo")
zip::zip("../test.zip", c("bar/file1", "bar2", "../foo2"))
}\if{html}{\out{</div>}}\preformatted{## Warning in warn_for_dotdot(data$key): Some paths reference parent directory,
## creating non-portable zip file
}\if{html}{\out{<div class="r">}}\preformatted{zip_list("../test.zip")[, "filename", drop = FALSE]
}\if{html}{\out{</div>}}\preformatted{##        filename
## 1     bar/file1
## 2         bar2/
## 3      ../foo2/
## 4 ../foo2/file3
}
}

\subsection{Cherry picking mode}{

In cherry picking mode, the selected files and directories
will be at the root of the archive. This mode is handy if you
want to select a subset of files and directories, possibly from
different paths and put all of the in the archive, at the top
level.

Here is an example with the same directory structure as above:\if{html}{\out{<div class="r">}}\preformatted{zip::zip(
  "../test2.zip",
  c("bar/file1", "bar2", "../foo2"),
  mode = "cherry-pick"
)
zip_list("../test2.zip")[, "filename", drop = FALSE]
}\if{html}{\out{</div>}}\preformatted{##     filename
## 1      file1
## 2      bar2/
## 3      foo2/
## 4 foo2/file3
}
}

}

\subsection{Permissions:}{

\code{zip()} (and \code{zip_append()}, etc.) add the permissions of
the archived files and directories to the ZIP archive, on Unix systems.
Most zip and unzip implementations support these, so they will be
recovered after extracting the archive.

Note, however that the owner and group (uid and gid) are currently
omitted, even on Unix.
}

\subsection{\code{zipr()} and \code{zipr_append()}}{

These function exist for historical reasons. They are identical
to \code{zip()} and \code{zipr_append()} with a different default for the
\code{mode} argument.
}
}
\examples{
## Some files to zip up. We will run all this in the R sesion's
## temporary directory, to avoid messing up the user's workspace.
dir.create(tmp <- tempfile())
dir.create(file.path(tmp, "mydir"))
cat("first file", file = file.path(tmp, "mydir", "file1"))
cat("second file", file = file.path(tmp, "mydir", "file2"))

zipfile <- tempfile(fileext = ".zip")
zip::zip(zipfile, "mydir", root = tmp)

## List contents
zip_list(zipfile)

## Add another file
cat("third file", file = file.path(tmp, "mydir", "file3"))
zip_append(zipfile, file.path("mydir", "file3"), root = tmp)
zip_list(zipfile)
}
