lines <- readLines('tools/errorcodes.txt')
errors <- grep('^CURLE', lines, value = TRUE)[-1]
error_codes <- sub(",.*", "", errors)
stopifnot(error_codes[100] == "CURLE_TOO_LARGE")
error_codes <- sub("^curle_", "curl_error_", tolower(error_codes))
out <- file('R/errcodes.R', 'w')
writeLines("# This file is autogenerated using make-errorcodes.R", out)
writeLines("libcurl_error_codes <- ", out)
dput(error_codes, out)
close(out)

