% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkOS.R
\name{checkOS}
\alias{checkOS}
\alias{check_os}
\alias{assertOS}
\alias{assert_os}
\alias{testOS}
\alias{test_os}
\alias{expect_os}
\title{Check the operating system}
\usage{
checkOS(os)

check_os(os)

assertOS(os, add = NULL, .var.name = NULL)

assert_os(os, add = NULL, .var.name = NULL)

testOS(os)

test_os(os)

expect_os(os, info = NULL, label = NULL)
}
\arguments{
\item{os}{[\code{character}]\cr
Check the operating system to be in a set with possible elements \dQuote{windows},
\dQuote{mac}, \dQuote{linux} and \dQuote{solaris}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertOS}/\code{assert_os} return 
 \code{x} invisibly, whereas
 \code{checkOS}/\code{check_os} and 
 \code{testOS}/\code{test_os} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertOS}/\code{assert_os}
 throws an error message, 
 \code{testOS}/\code{test_os}
 returns \code{FALSE},
 and \code{checkOS}/\code{check_os} 
 return a string with the error message.
 The function \code{expect_os} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check the operating system
}
\examples{
testOS("linux")
}
