# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.deviceregistry import DeviceRegistryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeviceRegistryMgmtNamespaceAssetsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeviceRegistryMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_assets_get(self, resource_group):
        response = self.client.namespace_assets.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            asset_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_assets_begin_create_or_replace(self, resource_group):
        response = self.client.namespace_assets.begin_create_or_replace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            asset_name="str",
            resource={
                "extendedLocation": {"name": "str", "type": "str"},
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "deviceRef": {"deviceName": "str", "endpointName": "str"},
                    "assetTypeRefs": ["str"],
                    "attributes": {"str": {}},
                    "datasets": [
                        {
                            "name": "str",
                            "dataPoints": [
                                {"dataSource": "str", "name": "str", "dataPointConfiguration": "str", "typeRef": "str"}
                            ],
                            "dataSource": "str",
                            "datasetConfiguration": "str",
                            "destinations": ["dataset_destination"],
                            "typeRef": "str",
                        }
                    ],
                    "defaultDatasetsConfiguration": "str",
                    "defaultDatasetsDestinations": ["dataset_destination"],
                    "defaultEventsConfiguration": "str",
                    "defaultEventsDestinations": ["event_destination"],
                    "defaultManagementGroupsConfiguration": "str",
                    "defaultStreamsConfiguration": "str",
                    "defaultStreamsDestinations": ["stream_destination"],
                    "description": "str",
                    "discoveredAssetRefs": ["str"],
                    "displayName": "str",
                    "documentationUri": "str",
                    "enabled": bool,
                    "eventGroups": [
                        {
                            "name": "str",
                            "dataSource": "str",
                            "defaultDestinations": ["event_destination"],
                            "eventGroupConfiguration": "str",
                            "events": [
                                {
                                    "name": "str",
                                    "dataSource": "str",
                                    "destinations": ["event_destination"],
                                    "eventConfiguration": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "typeRef": "str",
                        }
                    ],
                    "externalAssetId": "str",
                    "hardwareRevision": "str",
                    "lastTransitionTime": "2020-02-20 00:00:00",
                    "managementGroups": [
                        {
                            "name": "str",
                            "actions": [
                                {
                                    "name": "str",
                                    "targetUri": "str",
                                    "actionConfiguration": "str",
                                    "actionType": "str",
                                    "timeoutInSeconds": 0,
                                    "topic": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "defaultTimeoutInSeconds": 0,
                            "defaultTopic": "str",
                            "managementGroupConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "manufacturer": "str",
                    "manufacturerUri": "str",
                    "model": "str",
                    "productCode": "str",
                    "provisioningState": "str",
                    "serialNumber": "str",
                    "softwareRevision": "str",
                    "status": {
                        "config": {
                            "error": {
                                "code": "str",
                                "details": [{"code": "str", "correlationId": "str", "info": "str", "message": "str"}],
                                "message": "str",
                            },
                            "lastTransitionTime": "2020-02-20 00:00:00",
                            "version": 0,
                        },
                        "datasets": [
                            {
                                "name": "str",
                                "error": {
                                    "code": "str",
                                    "details": [
                                        {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                    ],
                                    "message": "str",
                                },
                                "messageSchemaReference": {
                                    "schemaName": "str",
                                    "schemaRegistryNamespace": "str",
                                    "schemaVersion": "str",
                                },
                            }
                        ],
                        "eventGroups": [
                            {
                                "name": "str",
                                "events": [
                                    {
                                        "name": "str",
                                        "error": {
                                            "code": "str",
                                            "details": [
                                                {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                            ],
                                            "message": "str",
                                        },
                                        "messageSchemaReference": {
                                            "schemaName": "str",
                                            "schemaRegistryNamespace": "str",
                                            "schemaVersion": "str",
                                        },
                                    }
                                ],
                            }
                        ],
                        "managementGroups": [
                            {
                                "name": "str",
                                "actions": [
                                    {
                                        "name": "str",
                                        "error": {
                                            "code": "str",
                                            "details": [
                                                {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                            ],
                                            "message": "str",
                                        },
                                        "requestMessageSchemaReference": {
                                            "schemaName": "str",
                                            "schemaRegistryNamespace": "str",
                                            "schemaVersion": "str",
                                        },
                                        "responseMessageSchemaReference": {
                                            "schemaName": "str",
                                            "schemaRegistryNamespace": "str",
                                            "schemaVersion": "str",
                                        },
                                    }
                                ],
                            }
                        ],
                        "streams": [
                            {
                                "name": "str",
                                "error": {
                                    "code": "str",
                                    "details": [
                                        {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                    ],
                                    "message": "str",
                                },
                                "messageSchemaReference": {
                                    "schemaName": "str",
                                    "schemaRegistryNamespace": "str",
                                    "schemaVersion": "str",
                                },
                            }
                        ],
                    },
                    "streams": [
                        {
                            "name": "str",
                            "destinations": ["stream_destination"],
                            "streamConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "uuid": "str",
                    "version": 0,
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_assets_begin_update(self, resource_group):
        response = self.client.namespace_assets.begin_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            asset_name="str",
            properties={
                "properties": {
                    "assetTypeRefs": ["str"],
                    "attributes": {"str": {}},
                    "datasets": [
                        {
                            "name": "str",
                            "dataPoints": [
                                {"dataSource": "str", "name": "str", "dataPointConfiguration": "str", "typeRef": "str"}
                            ],
                            "dataSource": "str",
                            "datasetConfiguration": "str",
                            "destinations": ["dataset_destination"],
                            "typeRef": "str",
                        }
                    ],
                    "defaultDatasetsConfiguration": "str",
                    "defaultDatasetsDestinations": ["dataset_destination"],
                    "defaultEventsConfiguration": "str",
                    "defaultEventsDestinations": ["event_destination"],
                    "defaultManagementGroupsConfiguration": "str",
                    "defaultStreamsConfiguration": "str",
                    "defaultStreamsDestinations": ["stream_destination"],
                    "description": "str",
                    "displayName": "str",
                    "documentationUri": "str",
                    "enabled": bool,
                    "eventGroups": [
                        {
                            "name": "str",
                            "dataSource": "str",
                            "defaultDestinations": ["event_destination"],
                            "eventGroupConfiguration": "str",
                            "events": [
                                {
                                    "name": "str",
                                    "dataSource": "str",
                                    "destinations": ["event_destination"],
                                    "eventConfiguration": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "typeRef": "str",
                        }
                    ],
                    "hardwareRevision": "str",
                    "managementGroups": [
                        {
                            "name": "str",
                            "actions": [
                                {
                                    "name": "str",
                                    "targetUri": "str",
                                    "actionConfiguration": "str",
                                    "actionType": "str",
                                    "timeoutInSeconds": 0,
                                    "topic": "str",
                                    "typeRef": "str",
                                }
                            ],
                            "dataSource": "str",
                            "defaultTimeoutInSeconds": 0,
                            "defaultTopic": "str",
                            "managementGroupConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                    "manufacturer": "str",
                    "manufacturerUri": "str",
                    "model": "str",
                    "productCode": "str",
                    "serialNumber": "str",
                    "softwareRevision": "str",
                    "streams": [
                        {
                            "name": "str",
                            "destinations": ["stream_destination"],
                            "streamConfiguration": "str",
                            "typeRef": "str",
                        }
                    ],
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_assets_begin_delete(self, resource_group):
        response = self.client.namespace_assets.begin_delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            asset_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespace_assets_list_by_resource_group(self, resource_group):
        response = self.client.namespace_assets.list_by_resource_group(
            resource_group_name=resource_group.name,
            namespace_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
