# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIContainerAppsAuthConfigsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_auth_configs_list_by_container_app(self, resource_group):
        response = self.client.container_apps_auth_configs.list_by_container_app(
            resource_group_name=resource_group.name,
            container_app_name="str",
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_auth_configs_get(self, resource_group):
        response = await self.client.container_apps_auth_configs.get(
            resource_group_name=resource_group.name,
            container_app_name="str",
            auth_config_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_auth_configs_create_or_update(self, resource_group):
        response = await self.client.container_apps_auth_configs.create_or_update(
            resource_group_name=resource_group.name,
            container_app_name="str",
            auth_config_name="str",
            auth_config_envelope={
                "encryptionSettings": {
                    "containerAppAuthEncryptionSecretName": "str",
                    "containerAppAuthSigningSecretName": "str",
                },
                "globalValidation": {
                    "excludedPaths": ["str"],
                    "redirectToProvider": "str",
                    "unauthenticatedClientAction": "str",
                },
                "httpSettings": {
                    "forwardProxy": {
                        "convention": "str",
                        "customHostHeaderName": "str",
                        "customProtoHeaderName": "str",
                    },
                    "requireHttps": bool,
                    "routes": {"apiPrefix": "str"},
                },
                "id": "str",
                "identityProviders": {
                    "apple": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "azureActiveDirectory": {
                        "enabled": bool,
                        "isAutoProvisioned": bool,
                        "login": {"disableWWWAuthenticate": bool, "loginParameters": ["str"]},
                        "registration": {
                            "clientId": "str",
                            "clientSecretCertificateIssuer": "str",
                            "clientSecretCertificateSubjectAlternativeName": "str",
                            "clientSecretCertificateThumbprint": "str",
                            "clientSecretSettingName": "str",
                            "openIdIssuer": "str",
                        },
                        "validation": {
                            "allowedAudiences": ["str"],
                            "defaultAuthorizationPolicy": {
                                "allowedApplications": ["str"],
                                "allowedPrincipals": {"groups": ["str"], "identities": ["str"]},
                            },
                            "jwtClaimChecks": {"allowedClientApplications": ["str"], "allowedGroups": ["str"]},
                        },
                    },
                    "azureStaticWebApps": {"enabled": bool, "registration": {"clientId": "str"}},
                    "customOpenIdConnectProviders": {
                        "str": {
                            "enabled": bool,
                            "login": {"nameClaimType": "str", "scopes": ["str"]},
                            "registration": {
                                "clientCredential": {"clientSecretSettingName": "str", "method": "ClientSecretPost"},
                                "clientId": "str",
                                "openIdConnectConfiguration": {
                                    "authorizationEndpoint": "str",
                                    "certificationUri": "str",
                                    "issuer": "str",
                                    "tokenEndpoint": "str",
                                    "wellKnownOpenIdConfiguration": "str",
                                },
                            },
                        }
                    },
                    "facebook": {
                        "enabled": bool,
                        "graphApiVersion": "str",
                        "login": {"scopes": ["str"]},
                        "registration": {"appId": "str", "appSecretSettingName": "str"},
                    },
                    "gitHub": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                    },
                    "google": {
                        "enabled": bool,
                        "login": {"scopes": ["str"]},
                        "registration": {"clientId": "str", "clientSecretSettingName": "str"},
                        "validation": {"allowedAudiences": ["str"]},
                    },
                    "twitter": {
                        "enabled": bool,
                        "registration": {"consumerKey": "str", "consumerSecretSettingName": "str"},
                    },
                },
                "login": {
                    "allowedExternalRedirectUrls": ["str"],
                    "cookieExpiration": {"convention": "str", "timeToExpiration": "str"},
                    "nonce": {"nonceExpirationInterval": "str", "validateNonce": bool},
                    "preserveUrlFragmentsForLogins": bool,
                    "routes": {"logoutEndpoint": "str"},
                    "tokenStore": {
                        "azureBlobStorage": {"sasUrlSettingName": "str"},
                        "enabled": bool,
                        "tokenRefreshExtensionHours": 0.0,
                    },
                },
                "name": "str",
                "platform": {"enabled": bool, "runtimeVersion": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_container_apps_auth_configs_delete(self, resource_group):
        response = await self.client.container_apps_auth_configs.delete(
            resource_group_name=resource_group.name,
            container_app_name="str",
            auth_config_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...
