#!/bin/bash
CUR_PATH=$(dirname  $(realpath $0))
source "$CUR_PATH/../test_utils/test_utils.sh"

app_name="my_cat"

APP_DIR="."
[ -n "$BUILD_DIR" ] && APP_DIR="$BUILD_DIR"
APP_PATH="${APP_DIR}/$app_name"
TRACE_DIRNAME="${APP_PATH}_trace"
trace_filename="${TRACE_DIRNAME}/eztrace_log.otf2"
EZTRACE_TEST_OPTION="$EZTRACE_TEST_OPTION -o ${TRACE_DIRNAME}"
[ -n "$EZTRACE_PATH" ] || EZTRACE_PATH=eztrace

input_file="${APP_DIR}/input_file.tmp"
output_file="${APP_DIR}/output_file.tmp"
size=1000
dd if=/dev/random of="$input_file" count=1000 bs=1

run_and_check_command "$EZTRACE_PATH" $EZTRACE_TEST_OPTION -t "posixio" "${APP_PATH}" "${input_file}" "$output_file"

trace_check_integrity "$trace_filename"
trace_check_enter_leave_parity  "$trace_filename"

nevent=$(echo "$size * 2 +1"|bc)
trace_check_event_type "$trace_filename" "IO_OPERATION_BEGIN" $nevent
trace_check_event_type "$trace_filename" "IO_OPERATION_COMPLETE" $nevent

echo PASS: $nb_pass, FAILED:$nb_failed, TOTAL: $nb_test

exit $nb_failed
