/*
 * Copyright (c) 2021, 2023-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <cstddef>
#include <cstdint>

#if defined(ARM_COMPUTE_ENABLE_SVE)

namespace arm_conv {
namespace depthwise {

void sve_fp32_packed_to_nhwc_5x5_s1_with_multiplier_output2x4_mla_depthfirst_impl(
  const float *const *const inptrs,
  float *const *const outptrs,
  const void *params,
  const unsigned int n_output_channels,
  const float activation_min,
  const float activation_max
)
{
  const float minmax_vals[2] = { activation_min, activation_max };

  __asm__ __volatile__(
    "mov x15, #0x0\n"
    "ptrue p2.b\n"
    "ldr x14, [%x[inptrs], #0x0]\n"
    "ldr x13, [%x[inptrs], #0x8]\n"
    "ldr x12, [%x[inptrs], #0x10]\n"
    "ldr x11, [%x[inptrs], #0x18]\n"
    "mov x10, #0x0\n"
    "ldr x9, [%x[inptrs], #0x20]\n"
    "ldr x28, [%x[inptrs], #0x28]\n"
    "whilelt p1.s, x15, %x[channel_multiplier]\n"
    "ldp x27, x26, [%x[outptrs], #0x0]\n"
    "ldp x25, x24, [%x[outptrs], #0x10]\n"
    "ldp x23, x22, [%x[outptrs], #0x20]\n"
    "ldp x21, x20, [%x[outptrs], #0x30]\n"
    "ld1w { z16.s }, p1/Z, [%x[params]]\n"
    "ld1rqw { z2.s }, p2/Z, [x14]\n"
    "ld1rqw { z3.s }, p2/Z, [x14, #16]\n"
    "ld1rqw { z4.s }, p2/Z, [x13]\n"
    "ld1rqw { z5.s }, p2/Z, [x13, #16]\n"
    "ld1rqw { z6.s }, p2/Z, [x12]\n"
    "ld1rqw { z7.s }, p2/Z, [x12, #16]\n"
    "ld1rqw { z8.s }, p2/Z, [x11]\n"
    "mov z25.d, z16.d\n"
    "mov z15.d, z16.d\n"
    "ld1rqw { z9.s }, p2/Z, [x11, #16]\n"
    "ld1rqw { z10.s }, p2/Z, [x9]\n"
    "mov z24.d, z16.d\n"
    "mov z14.d, z16.d\n"
    "ld1rqw { z11.s }, p2/Z, [x9, #16]\n"
    "ld1rqw { z12.s }, p2/Z, [x28]\n"
    "mov z26.d, z16.d\n"
    "mov z17.d, z16.d\n"
    "ld1rqw { z13.s }, p2/Z, [x28, #16]\n"
    "ld1rw { z23.s }, p2/Z, [%x[clamps]]\n"
    "mov z21.d, z16.d\n"
    "ld1rw { z22.s }, p2/Z, [%x[clamps], #4]\n"
    "ld1w { z31.s }, p1/Z, [%x[params], #1, MUL VL]\n"
    "ld1w { z30.s }, p1/Z, [%x[params], #2, MUL VL]\n"
    "ld1w { z29.s }, p1/Z, [%x[params], #3, MUL VL]\n"
    "ld1w { z28.s }, p1/Z, [%x[params], #4, MUL VL]\n"
    "ld1w { z27.s }, p1/Z, [%x[params], #5, MUL VL]\n"
    "addvl %x[params], %x[params], #6\n"
    "1:"  // Output channel complete vector loop
    "fmla z16.s, z31.s, z2.s[0]\n"
    "fmla z25.s, z31.s, z2.s[1]\n"
    "mov z0.d, z8.d\n"
    "incw x15\n"
    "fmla z15.s, z31.s, z2.s[2]\n"
    "fmla z24.s, z31.s, z2.s[3]\n"
    "mov z1.d, z9.d\n"
    "mov p0.b, p1.b\n"
    "fmla z14.s, z31.s, z4.s[0]\n"
    "fmla z26.s, z31.s, z4.s[1]\n"
    "fmla z17.s, z31.s, z4.s[2]\n"
    "fmla z21.s, z31.s, z4.s[3]\n"
    "ld1w { z20.s }, p2/Z, [%x[params]]\n"
    "whilelt p1.s, x15, %x[channel_multiplier]\n"
    "fmla z16.s, z30.s, z2.s[1]\n"
    "fmla z25.s, z30.s, z2.s[2]\n"
    "fmla z15.s, z30.s, z2.s[3]\n"
    "fmla z24.s, z30.s, z3.s[0]\n"
    "fmla z14.s, z30.s, z4.s[1]\n"
    "fmla z26.s, z30.s, z4.s[2]\n"
    "fmla z17.s, z30.s, z4.s[3]\n"
    "fmla z21.s, z30.s, z5.s[0]\n"
    "ld1w { z19.s }, p2/Z, [%x[params], #1, MUL VL]\n"
    "fmla z16.s, z29.s, z2.s[2]\n"
    "fmla z25.s, z29.s, z2.s[3]\n"
    "fmla z15.s, z29.s, z3.s[0]\n"
    "fmla z24.s, z29.s, z3.s[1]\n"
    "fmla z14.s, z29.s, z4.s[2]\n"
    "fmla z26.s, z29.s, z4.s[3]\n"
    "fmla z17.s, z29.s, z5.s[0]\n"
    "fmla z21.s, z29.s, z5.s[1]\n"
    "ld1w { z18.s }, p2/Z, [%x[params], #2, MUL VL]\n"
    "fmla z16.s, z28.s, z2.s[3]\n"
    "fmla z25.s, z28.s, z3.s[0]\n"
    "fmla z15.s, z28.s, z3.s[1]\n"
    "fmla z24.s, z28.s, z3.s[2]\n"
    "fmla z14.s, z28.s, z4.s[3]\n"
    "fmla z26.s, z28.s, z5.s[0]\n"
    "fmla z17.s, z28.s, z5.s[1]\n"
    "fmla z21.s, z28.s, z5.s[2]\n"
    "ld1w { z30.s }, p2/Z, [%x[params], #3, MUL VL]\n"
    "fmla z16.s, z27.s, z3.s[0]\n"
    "fmla z25.s, z27.s, z3.s[1]\n"
    "fmla z15.s, z27.s, z3.s[2]\n"
    "fmla z24.s, z27.s, z3.s[3]\n"
    "fmla z14.s, z27.s, z5.s[0]\n"
    "fmla z26.s, z27.s, z5.s[1]\n"
    "fmla z17.s, z27.s, z5.s[2]\n"
    "fmla z21.s, z27.s, z5.s[3]\n"
    "ld1w { z27.s }, p2/Z, [%x[params], #4, MUL VL]\n"
    "fmla z16.s, z20.s, z4.s[0]\n"
    "fmla z25.s, z20.s, z4.s[1]\n"
    "fmla z15.s, z20.s, z4.s[2]\n"
    "fmla z24.s, z20.s, z4.s[3]\n"
    "fmla z14.s, z20.s, z6.s[0]\n"
    "fmla z26.s, z20.s, z6.s[1]\n"
    "fmla z17.s, z20.s, z6.s[2]\n"
    "fmla z21.s, z20.s, z6.s[3]\n"
    "ld1w { z20.s }, p2/Z, [%x[params], #5, MUL VL]\n"
    "fmla z16.s, z19.s, z4.s[1]\n"
    "fmla z25.s, z19.s, z4.s[2]\n"
    "fmla z15.s, z19.s, z4.s[3]\n"
    "fmla z24.s, z19.s, z5.s[0]\n"
    "fmla z14.s, z19.s, z6.s[1]\n"
    "fmla z26.s, z19.s, z6.s[2]\n"
    "fmla z17.s, z19.s, z6.s[3]\n"
    "fmla z21.s, z19.s, z7.s[0]\n"
    "ld1w { z19.s }, p2/Z, [%x[params], #6, MUL VL]\n"
    "fmla z16.s, z18.s, z4.s[2]\n"
    "fmla z25.s, z18.s, z4.s[3]\n"
    "fmla z15.s, z18.s, z5.s[0]\n"
    "fmla z24.s, z18.s, z5.s[1]\n"
    "fmla z14.s, z18.s, z6.s[2]\n"
    "fmla z26.s, z18.s, z6.s[3]\n"
    "fmla z17.s, z18.s, z7.s[0]\n"
    "fmla z21.s, z18.s, z7.s[1]\n"
    "ld1w { z29.s }, p2/Z, [%x[params], #7, MUL VL]\n"
    "addvl %x[params], %x[params], #16\n"
    "fmla z16.s, z30.s, z4.s[3]\n"
    "fmla z25.s, z30.s, z5.s[0]\n"
    "fmla z15.s, z30.s, z5.s[1]\n"
    "fmla z24.s, z30.s, z5.s[2]\n"
    "fmla z14.s, z30.s, z6.s[3]\n"
    "fmla z26.s, z30.s, z7.s[0]\n"
    "fmla z17.s, z30.s, z7.s[1]\n"
    "fmla z21.s, z30.s, z7.s[2]\n"
    "ld1w { z18.s }, p2/Z, [%x[params], #-8, MUL VL]\n"
    "fmla z16.s, z27.s, z5.s[0]\n"
    "fmla z25.s, z27.s, z5.s[1]\n"
    "fmla z15.s, z27.s, z5.s[2]\n"
    "fmla z24.s, z27.s, z5.s[3]\n"
    "fmla z14.s, z27.s, z7.s[0]\n"
    "fmla z26.s, z27.s, z7.s[1]\n"
    "fmla z17.s, z27.s, z7.s[2]\n"
    "fmla z21.s, z27.s, z7.s[3]\n"
    "ld1w { z27.s }, p2/Z, [%x[params], #-7, MUL VL]\n"
    "fmla z16.s, z20.s, z6.s[0]\n"
    "fmla z25.s, z20.s, z6.s[1]\n"
    "fmla z15.s, z20.s, z6.s[2]\n"
    "fmla z24.s, z20.s, z6.s[3]\n"
    "fmla z14.s, z20.s, z0.s[0]\n"
    "fmla z26.s, z20.s, z0.s[1]\n"
    "fmla z17.s, z20.s, z0.s[2]\n"
    "fmla z21.s, z20.s, z0.s[3]\n"
    "ld1w { z20.s }, p2/Z, [%x[params], #-6, MUL VL]\n"
    "fmla z16.s, z19.s, z6.s[1]\n"
    "fmla z25.s, z19.s, z6.s[2]\n"
    "fmla z15.s, z19.s, z6.s[3]\n"
    "fmla z24.s, z19.s, z7.s[0]\n"
    "fmla z14.s, z19.s, z0.s[1]\n"
    "fmla z26.s, z19.s, z0.s[2]\n"
    "fmla z17.s, z19.s, z0.s[3]\n"
    "fmla z21.s, z19.s, z1.s[0]\n"
    "ld1w { z19.s }, p2/Z, [%x[params], #-5, MUL VL]\n"
    "fmla z16.s, z29.s, z6.s[2]\n"
    "fmla z25.s, z29.s, z6.s[3]\n"
    "fmla z15.s, z29.s, z7.s[0]\n"
    "fmla z24.s, z29.s, z7.s[1]\n"
    "fmla z14.s, z29.s, z0.s[2]\n"
    "fmla z26.s, z29.s, z0.s[3]\n"
    "fmla z17.s, z29.s, z1.s[0]\n"
    "fmla z21.s, z29.s, z1.s[1]\n"
    "ld1w { z30.s }, p2/Z, [%x[params], #-4, MUL VL]\n"
    "fmla z16.s, z18.s, z6.s[3]\n"
    "fmla z25.s, z18.s, z7.s[0]\n"
    "fmla z15.s, z18.s, z7.s[1]\n"
    "fmla z24.s, z18.s, z7.s[2]\n"
    "fmla z14.s, z18.s, z0.s[3]\n"
    "fmla z26.s, z18.s, z1.s[0]\n"
    "fmla z17.s, z18.s, z1.s[1]\n"
    "fmla z21.s, z18.s, z1.s[2]\n"
    "ld1w { z28.s }, p2/Z, [%x[params], #-3, MUL VL]\n"
    "fmla z16.s, z27.s, z7.s[0]\n"
    "fmla z25.s, z27.s, z7.s[1]\n"
    "fmla z15.s, z27.s, z7.s[2]\n"
    "fmla z24.s, z27.s, z7.s[3]\n"
    "fmla z14.s, z27.s, z1.s[0]\n"
    "fmla z26.s, z27.s, z1.s[1]\n"
    "fmla z17.s, z27.s, z1.s[2]\n"
    "fmla z21.s, z27.s, z1.s[3]\n"
    "ld1w { z27.s }, p2/Z, [%x[params], #-2, MUL VL]\n"
    "fmla z16.s, z20.s, z0.s[0]\n"
    "fmla z25.s, z20.s, z0.s[1]\n"
    "fmla z15.s, z20.s, z0.s[2]\n"
    "fmla z24.s, z20.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "fmla z14.s, z20.s, z0.s[0]\n"
    "fmla z26.s, z20.s, z0.s[1]\n"
    "fmla z17.s, z20.s, z0.s[2]\n"
    "fmla z21.s, z20.s, z0.s[3]\n"
    "mov z0.d, z8.d\n"
    "ld1w { z31.s }, p2/Z, [%x[params], #-1, MUL VL]\n"
    "fmla z16.s, z19.s, z0.s[1]\n"
    "fmla z25.s, z19.s, z0.s[2]\n"
    "fmla z15.s, z19.s, z0.s[3]\n"
    "fmla z24.s, z19.s, z1.s[0]\n"
    "mov z0.d, z10.d\n"
    "mov z1.d, z11.d\n"
    "fmla z14.s, z19.s, z0.s[1]\n"
    "fmla z26.s, z19.s, z0.s[2]\n"
    "fmla z17.s, z19.s, z0.s[3]\n"
    "mov z0.d, z8.d\n"
    "fmla z21.s, z19.s, z1.s[0]\n"
    "ld1w { z20.s }, p2/Z, [%x[params]]\n"
    "mov z1.d, z9.d\n"
    "fmla z16.s, z30.s, z0.s[2]\n"
    "fmla z25.s, z30.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "fmla z15.s, z30.s, z1.s[0]\n"
    "fmla z24.s, z30.s, z1.s[1]\n"
    "mov z1.d, z11.d\n"
    "fmla z14.s, z30.s, z0.s[2]\n"
    "fmla z26.s, z30.s, z0.s[3]\n"
    "mov z0.d, z8.d\n"
    "fmla z17.s, z30.s, z1.s[0]\n"
    "fmla z21.s, z30.s, z1.s[1]\n"
    "ld1w { z19.s }, p2/Z, [%x[params], #1, MUL VL]\n"
    "mov z1.d, z9.d\n"
    "fmla z16.s, z28.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "fmla z25.s, z28.s, z1.s[0]\n"
    "fmla z15.s, z28.s, z1.s[1]\n"
    "fmla z24.s, z28.s, z1.s[2]\n"
    "mov z1.d, z11.d\n"
    "fmla z14.s, z28.s, z0.s[3]\n"
    "fmla z26.s, z28.s, z1.s[0]\n"
    "fmla z17.s, z28.s, z1.s[1]\n"
    "fmla z21.s, z28.s, z1.s[2]\n"
    "mov z1.d, z9.d\n"
    "ld1w { z18.s }, p2/Z, [%x[params], #2, MUL VL]\n"
    "fmla z16.s, z27.s, z1.s[0]\n"
    "fmla z25.s, z27.s, z1.s[1]\n"
    "fmla z15.s, z27.s, z1.s[2]\n"
    "fmla z24.s, z27.s, z1.s[3]\n"
    "mov z1.d, z11.d\n"
    "fmla z14.s, z27.s, z1.s[0]\n"
    "fmla z26.s, z27.s, z1.s[1]\n"
    "fmla z17.s, z27.s, z1.s[2]\n"
    "fmla z21.s, z27.s, z1.s[3]\n"
    "fmla z16.s, z31.s, z0.s[0]\n"
    "ld1w { z28.s }, p2/Z, [%x[params], #3, MUL VL]\n"
    "fmla z25.s, z31.s, z0.s[1]\n"
    "fmla z15.s, z31.s, z0.s[2]\n"
    "fmla z24.s, z31.s, z0.s[3]\n"
    "mov z0.d, z12.d\n"
    "fmla z14.s, z31.s, z0.s[0]\n"
    "fmla z26.s, z31.s, z0.s[1]\n"
    "fmla z17.s, z31.s, z0.s[2]\n"
    "fmla z21.s, z31.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "ld1w { z31.s }, p1/Z, [%x[params], #5, MUL VL]\n"
    "fmla z16.s, z20.s, z0.s[1]\n"
    "fmla z25.s, z20.s, z0.s[2]\n"
    "fmla z15.s, z20.s, z0.s[3]\n"
    "mov z0.d, z12.d\n"
    "fmla z24.s, z20.s, z1.s[0]\n"
    "mov z1.d, z13.d\n"
    "fmla z14.s, z20.s, z0.s[1]\n"
    "fmla z26.s, z20.s, z0.s[2]\n"
    "fmla z17.s, z20.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "fmla z21.s, z20.s, z1.s[0]\n"
    "mov z1.d, z11.d\n"
    "ld1w { z30.s }, p1/Z, [%x[params], #6, MUL VL]\n"
    "fmla z16.s, z19.s, z0.s[2]\n"
    "fmla z25.s, z19.s, z0.s[3]\n"
    "mov z0.d, z12.d\n"
    "fmla z15.s, z19.s, z1.s[0]\n"
    "fmla z24.s, z19.s, z1.s[1]\n"
    "mov z1.d, z13.d\n"
    "fmla z14.s, z19.s, z0.s[2]\n"
    "fmla z26.s, z19.s, z0.s[3]\n"
    "mov z0.d, z10.d\n"
    "fmla z17.s, z19.s, z1.s[0]\n"
    "fmla z21.s, z19.s, z1.s[1]\n"
    "mov z1.d, z11.d\n"
    "ld1w { z29.s }, p1/Z, [%x[params], #7, MUL VL]\n"
    "fmla z16.s, z18.s, z0.s[3]\n"
    "mov z0.d, z12.d\n"
    "fmla z25.s, z18.s, z1.s[0]\n"
    "fmla z15.s, z18.s, z1.s[1]\n"
    "fmla z24.s, z18.s, z1.s[2]\n"
    "mov z1.d, z13.d\n"
    "fmla z14.s, z18.s, z0.s[3]\n"
    "fmla z26.s, z18.s, z1.s[0]\n"
    "fmla z17.s, z18.s, z1.s[1]\n"
    "fmla z21.s, z18.s, z1.s[2]\n"
    "mov z0.d, z11.d\n"
    "fmla z16.s, z28.s, z0.s[0]\n"
    "fmla z25.s, z28.s, z0.s[1]\n"
    "fmla z15.s, z28.s, z0.s[2]\n"
    "fmla z24.s, z28.s, z0.s[3]\n"
    "mov z0.d, z13.d\n"
    "fmla z14.s, z28.s, z0.s[0]\n"
    "fmla z26.s, z28.s, z0.s[1]\n"
    "fmla z17.s, z28.s, z0.s[2]\n"
    "fmla z21.s, z28.s, z0.s[3]\n"
    "fmin z16.s, p2/M, z16.s, z22.s\n"
    "fmin z25.s, p2/M, z25.s, z22.s\n"
    "fmin z15.s, p2/M, z15.s, z22.s\n"
    "fmin z24.s, p2/M, z24.s, z22.s\n"
    "fmin z14.s, p2/M, z14.s, z22.s\n"
    "fmax z16.s, p2/M, z16.s, z23.s\n"
    "fmin z26.s, p2/M, z26.s, z22.s\n"
    "fmin z17.s, p2/M, z17.s, z22.s\n"
    "fmin z21.s, p2/M, z21.s, z22.s\n"
    "fmax z25.s, p2/M, z25.s, z23.s\n"
    "st1w { z16.s }, p0, [x27, x10, LSL #2]\n"
    "ld1w { z16.s }, p1/Z, [%x[params], #4, MUL VL]\n"
    "addvl %x[params], %x[params], #16\n"
    "fmax z15.s, p2/M, z15.s, z23.s\n"
    "fmax z24.s, p2/M, z24.s, z23.s\n"
    "fmax z14.s, p2/M, z14.s, z23.s\n"
    "fmax z26.s, p2/M, z26.s, z23.s\n"
    "fmax z17.s, p2/M, z17.s, z23.s\n"
    "st1w { z25.s }, p0, [x26, x10, LSL #2]\n"
    "mov z25.d, z16.d\n"
    "fmax z21.s, p2/M, z21.s, z23.s\n"
    "st1w { z15.s }, p0, [x25, x10, LSL #2]\n"
    "mov z15.d, z16.d\n"
    "ld1w { z28.s }, p1/Z, [%x[params], #-8, MUL VL]\n"
    "st1w { z24.s }, p0, [x24, x10, LSL #2]\n"
    "mov z24.d, z16.d\n"
    "ld1w { z27.s }, p1/Z, [%x[params], #-7, MUL VL]\n"
    "addvl %x[params], %x[params], #-6\n"
    "st1w { z14.s }, p0, [x23, x10, LSL #2]\n"
    "mov z14.d, z16.d\n"
    "st1w { z26.s }, p0, [x22, x10, LSL #2]\n"
    "mov z26.d, z16.d\n"
    "st1w { z17.s }, p0, [x21, x10, LSL #2]\n"
    "mov z17.d, z16.d\n"
    "st1w { z21.s }, p0, [x20, x10, LSL #2]\n"
    "incw x10\n"
    "mov z21.d, z16.d\n"
    "b.any 1b\n"
    : [params] "+&r" (params)
    : [channel_multiplier] "r" (n_output_channels), [clamps] "r" (minmax_vals), [inptrs] "r" (inptrs), [outptrs] "r" (outptrs)
    : "cc", "memory", "p0", "p1", "p2", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SVE)
