# 2023-05-16 Triage Log

The last two weeks mostly have small changes across a number of benchmarks, no
widespread large regressions or improvements.

Triage done by **@simulacrum**.
Revision range: [a368898d..3ea9ad532](https://perf.rust-lang.org/?start=a368898de758e1b8def6c9060044a5b40eb79e84&end=3ea9ad532474343426e564b997891e459cda89a6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.2%, 2.0%]   | 96    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.2%, 3.2%]   | 60    |
| Improvements ✅ <br /> (primary)   | -1.3% | [-4.4%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -3.3% | [-7.2%, -0.6%] | 16    |
| All ❌✅ (primary)                 | 0.6%  | [-4.4%, 2.0%]  | 106   |


6 Regressions, 3 Improvements, 4 Mixed; 2 of them in rollups
90 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#111248](https://github.com/rust-lang/rust/pull/111248) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4a18324a4df6bc98bec0b54d35908d7a9cdc7c32&end=4b94c232192b0fa0314b5afa18e366356e210c4c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.5%, 1.6%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Minor regression limited to the `coercion` benchmark.

Populate effective visibilities in 'rustc_privacy'  [#110907](https://github.com/rust-lang/rust/pull/110907) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=905d5a38d69328385ce9963c65c385734c60322d&end=31a4f2da575f5e335bdbbe7f12a694f9e74ad0a1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.6%] | 72    |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 1.2%] | 15    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.6%] | 72    |

Populate effective visibilities in `rustc_privacy` (take 2) [#111425](https://github.com/rust-lang/rust/pull/111425) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2e18605af29ccf875cdcb539a522f11f5ac44113&end=ad6ab11234ae885913229f6de2c4465bdc0d76f3&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.4%, 1.5%] | 25    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.3%, 1.0%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.4%, 1.5%] | 25    |

[#111260](https://github.com/rust-lang/rust/pull/111260) addresses performance regressions in these two PRs.

Disable nrvo mir opt [#111007](https://github.com/rust-lang/rust/pull/111007) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a0111af531178e48375f14f838d7a2298524067c&end=dfe31889e10e36eed53327d1ca624fbf21b475a5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 2.1%] | 109   |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.1%, 0.9%] | 55    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 2.1%] | 109   |

Disables an optimization known to have miscompilations. Eventually we should
re-land something that has similar benefits.

Use dynamic dispatch for queries [#108638](https://github.com/rust-lang/rust/pull/108638) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3603a84a3d74d0b70dbbdaa47ed8f8a306f3fe7f&end=8e8116cfe5b1affcfcc22ffb6bb0152573488114&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.3%, 1.0%] | 74    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.1%, 2.2%] | 61    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.3%, 1.0%] | 74    |

Cuts bootstrap compile times (33% win for rustc_query_impl), some further work is expected to regain some of the lost performance.

Combine three generalizer implementations [#111221](https://github.com/rust-lang/rust/pull/111221) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ce5919fcef67103098219e1868f741e56fc90963&end=ea54255501221b26bf2242c09cbd0924dc8ee1ea&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.3%, 0.8%] | 11    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.3%, 0.8%] | 11    |

Regression is relatively small and plausibly due to slight optimization changes; did not occur in original perf run.

#### Improvements

Restrict `From<S>` for `{D,Subd}iagnosticMessage`. [#110579](https://github.com/rust-lang/rust/pull/110579) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b4571bed994a901e6dbd0b28e25e91a57758c549&end=71af5c4074cf1993551c10d8e4a1d6da9c27ce33&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.5%] | 5     |
| All ❌✅ (primary)                 | -0.5% | [-0.5%, -0.4%] | 3     |

Rollup of 6 pull requests [#111414](https://github.com/rust-lang/rust/pull/111414) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=63fc57b98eea5d6d84f1ccc4dbfcb12d58ad430b&end=25444e5a2e7293dbb4932df1301b9be4222244fe&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -5.7% | [-5.7%, -5.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -5.7% | [-5.7%, -5.7%] | 1     |

Align unsized locals [#111374](https://github.com/rust-lang/rust/pull/111374) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1623978dc41701201ec4daf36b3f748d661e7194&end=2c41369acc445d04129db40ba998dd7a89fb0d2e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 2     |


#### Mixed

Update hashbrown from 0.12.3 to 0.13.1 for std [#111306](https://github.com/rust-lang/rust/pull/111306) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c4190f2d3a46a59f435f7b42f58bc22b2f4d6917&end=ad6b20bf5225c65aab30169c9a173719f5bdfc04&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.0%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.5%] | 4     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.4%]  | 5     |

Uplift `clippy::{drop,forget}_{ref,copy}` lints [#109732](https://github.com/rust-lang/rust/pull/109732) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b795044c6f0854445f1f2bb6443e87848e150d1&end=077fc26f0acfa54e9c580534616c17ffc279a9d4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.8%]   | 5     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.9%, -1.0%] | 4     |
| All ❌✅ (primary)                 | 0.5%  | [0.4%, 0.8%]   | 5     |

Remove useless `assume`s from `slice::iter(_mut)` [#111447](https://github.com/rust-lang/rust/pull/111447) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9850584a4e5e4b7e5cebd9d90c27d8b88591f264&end=16d3e18281fde75eb6c62ebb8363af28de8a3ef0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.7%, -0.3%] | 85    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.4%, -0.4%] | 46    |
| All ❌✅ (primary)                 | -0.8% | [-1.7%, -0.3%] | 85    |

Fix the `FileEncoder` buffer size. [#111088](https://github.com/rust-lang/rust/pull/111088) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0bcfd2d96efe7a2cb5205c3af1b9eea17423fe65&end=8006510ab0f69ee75e9c3f7e8bff3776886dae51&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.1%  | [2.1%, 2.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 12    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.3%] | 10    |
