root_dir=$(pwd)

for f in $(find -name '*.re'); do
    cd $(dirname $f)

    hsfile="$(basename ${f%.re}.hs)"
    hstest="example.hs"

    cat "$hsfile" \
        | egrep -v 'warning: rule .*matches empty string \[-Wmatch-empty-string\]' \
        | egrep -v 'warning: tag .* degree of nondeterminism \[-Wnondeterministic-tags\]' \
        > "$hstest"

    test -n "$(grep 'main :: IO ()' $hstest)" || continue

    # If the autogenerated message appears more than once in the file, then
    # it must have autogenerated header appended at the end. Cut it off.
    msg='Generated by re2c'
    if [ $(grep -c "$msg" "$hstest") -gt 1 ]; then
        # Get the line of the second message occurrence.
        l=$(grep -n "$msg" "$hstest" | tail -n +2 | cut -d : -f 1)
        # Cut off everything past that line.
        head -n $l "$hstest" > "$hstest".mod && mv "$hstest".mod "$hstest"
    fi

    extra_args=`egrep -o -- '--header [^ ]+' "$hstest" | sed -E 's/--header (.*)/-i \1/'`

    echo "$f"
    ghc "$hstest" $extra_args -O2 -Wall -o example && ./example \
        || { echo "*** error ***"; exit 1; }

    rm -f "$hstest" example $(find -name '*.o' -o -name '*.hi')
    cd $root_dir
done

rm -f "$hstest"
echo "All good."
