% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{PlotPerturbScore}
\alias{PlotPerturbScore}
\title{Function to plot perturbation score distributions.}
\usage{
PlotPerturbScore(
  object,
  target.gene.class = "gene",
  target.gene.ident = NULL,
  mixscape.class = "mixscape_class",
  col = "orange2",
  split.by = NULL,
  before.mixscape = FALSE,
  prtb.type = "KO"
)
}
\arguments{
\item{object}{An object of class Seurat.}

\item{target.gene.class}{meta data column specifying all target gene names in the experiment.}

\item{target.gene.ident}{Target gene name to visualize perturbation scores for.}

\item{mixscape.class}{meta data column specifying mixscape classifications.}

\item{col}{Specify color of target gene class or knockout cell class. For
control non-targeting and non-perturbed cells, colors are set to different
shades of grey.}

\item{split.by}{For datasets with more than one cell type. Set equal TRUE to visualize perturbation scores for each cell type separately.}

\item{before.mixscape}{Option to split densities based on mixscape classification (default) or original target gene classification.
Default is set to NULL and plots cells by original class ID.}

\item{prtb.type}{specify type of CRISPR perturbation expected for labeling mixscape classifications. Default is KO.}
}
\value{
A ggplot object.
}
\description{
Density plots to visualize perturbation scores calculated from RunMixscape
function.
}
\concept{mixscape}
