% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stack.R
\name{.eval_ard_calls}
\alias{.eval_ard_calls}
\title{Evaluate the \verb{ard_*()} function calls}
\usage{
.eval_ard_calls(data, .by, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{.by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by in the series of ARD function calls}

\item{...}{(\code{\link[rlang:dyn-dots]{dynamic-dots}})\cr
Series of ARD function calls to be run and stacked}
}
\value{
list of ARD data frames of class 'card'
}
\description{
Evaluate the \verb{ard_*()} function calls
}
\examples{
cards:::.eval_ard_calls(
  data = ADSL,
  .by = "ARM",
  ard_tabulate(variables = "AGEGR1"),
  ard_summary(variables = "AGE")
)
}
\keyword{internal}
