# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AccessPolicyEntry(_Model):
    """An identity that have access to the key vault. All identities in the array must use the same
    tenant ID as the key vault's tenant ID.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar object_id: The object ID of a user, service principal or security group in the Azure
     Active Directory tenant for the vault. The object ID must be unique for the list of access
     policies. Required.
    :vartype object_id: str
    :ivar application_id: Application ID of the client making request on behalf of a principal.
    :vartype application_id: str
    :ivar permissions: Permissions the identity has for keys, secrets and certificates. Required.
    :vartype permissions: ~azure.mgmt.keyvault.models.Permissions
    """

    tenant_id: str = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the key
     vault. Required."""
    object_id: str = rest_field(name="objectId", visibility=["read", "create", "update", "delete", "query"])
    """The object ID of a user, service principal or security group in the Azure Active Directory
     tenant for the vault. The object ID must be unique for the list of access policies. Required."""
    application_id: Optional[str] = rest_field(
        name="applicationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application ID of the client making request on behalf of a principal."""
    permissions: "_models.Permissions" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Permissions the identity has for keys, secrets and certificates. Required."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: str,
        object_id: str,
        permissions: "_models.Permissions",
        application_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Action(_Model):
    """Action.

    :ivar type: The type of action. Known values are: "rotate" and "notify".
    :vartype type: str or ~azure.mgmt.keyvault.models.KeyRotationPolicyActionType
    """

    type: Optional[Union[str, "_models.KeyRotationPolicyActionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of action. Known values are: \"rotate\" and \"notify\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.KeyRotationPolicyActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Attributes(_Model):
    """The object attributes managed by the KeyVault service.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: ~datetime.datetime
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Determines whether the object is enabled."""
    not_before: Optional[datetime.datetime] = rest_field(
        name="nbf", visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """Not before date in seconds since 1970-01-01T00:00:00Z."""
    expires: Optional[datetime.datetime] = rest_field(
        name="exp", visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """Expiry date in seconds since 1970-01-01T00:00:00Z."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Creation time in seconds since 1970-01-01T00:00:00Z."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Last updated time in seconds since 1970-01-01T00:00:00Z."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckMhsmNameAvailabilityParameters(_Model):
    """The parameters used to check the availability of the managed hsm name.

    :ivar name: The managed hsm name. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The managed hsm name. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckMhsmNameAvailabilityResult(_Model):
    """The CheckMhsmNameAvailability operation response.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a managed hsm name could not be used. The reason element is only
     returned if NameAvailable is false. Known values are: "AccountNameInvalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """A boolean value that indicates whether the name is available for you to use. If true, the name
     is available. If false, the name has already been taken or is invalid and cannot be used."""
    reason: Optional[Union[str, "_models.Reason"]] = rest_field(visibility=["read"])
    """The reason that a managed hsm name could not be used. The reason element is only returned if
     NameAvailable is false. Known values are: \"AccountNameInvalid\" and \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """An error message explaining the Reason value in more detail."""


class CheckNameAvailabilityResult(_Model):
    """The CheckNameAvailability operation response.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason element is only
     returned if NameAvailable is false. Known values are: "AccountNameInvalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """A boolean value that indicates whether the name is available for you to use. If true, the name
     is available. If false, the name has already been taken or is invalid and cannot be used."""
    reason: Optional[Union[str, "_models.Reason"]] = rest_field(visibility=["read"])
    """The reason that a vault name could not be used. The Reason element is only returned if
     NameAvailable is false. Known values are: \"AccountNameInvalid\" and \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """An error message explaining the Reason value in more detail."""


class CloudError(_Model):
    """An error response from Key Vault resource provider.

    :ivar error: An error response from Key Vault resource provider.
    :vartype error: ~azure.mgmt.keyvault.models.CloudErrorBody
    """

    error: Optional["_models.CloudErrorBody"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An error response from Key Vault resource provider."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.CloudErrorBody"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudErrorBody(_Model):
    """An error response from Key Vault resource provider.

    :ivar code: Error code. This is a mnemonic that can be consumed programmatically.
    :vartype code: str
    :ivar message: User friendly error message. The message is typically localized and may vary
     with service version.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code. This is a mnemonic that can be consumed programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User friendly error message. The message is typically localized and may vary with service
     version."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    """


class DeletedManagedHsm(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Properties of the deleted managed HSM.
    :vartype properties: ~azure.mgmt.keyvault.models.DeletedManagedHsmProperties
    """

    properties: Optional["_models.DeletedManagedHsmProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the deleted managed HSM."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DeletedManagedHsmProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedManagedHsmProperties(_Model):
    """Properties of the deleted managed HSM.

    :ivar mhsm_id: The resource id of the original managed HSM.
    :vartype mhsm_id: str
    :ivar location: The location of the original managed HSM.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar purge_protection_enabled: Purge protection status of the original managed HSM.
    :vartype purge_protection_enabled: bool
    :ivar tags: Tags of the original managed HSM.
    :vartype tags: dict[str, str]
    """

    mhsm_id: Optional[str] = rest_field(name="mhsmId", visibility=["read"])
    """The resource id of the original managed HSM."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The location of the original managed HSM."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """The deleted date."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="rfc3339"
    )
    """The scheduled purged date."""
    purge_protection_enabled: Optional[bool] = rest_field(name="purgeProtectionEnabled", visibility=["read"])
    """Purge protection status of the original managed HSM."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags of the original managed HSM."""


class DeletedVault(ProxyResource):
    """Deleted vault information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.models.DeletedVaultProperties
    """

    properties: Optional["_models.DeletedVaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the vault."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DeletedVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedVaultProperties(_Model):
    """Properties of the deleted vault.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original vault.
    :vartype tags: dict[str, str]
    :ivar purge_protection_enabled: Purge protection status of the original vault.
    :vartype purge_protection_enabled: bool
    """

    vault_id: Optional[str] = rest_field(name="vaultId", visibility=["read"])
    """The resource id of the original vault."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The location of the original vault."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """The deleted date."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="rfc3339"
    )
    """The scheduled purged date."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags of the original vault."""
    purge_protection_enabled: Optional[bool] = rest_field(name="purgeProtectionEnabled", visibility=["read"])
    """Purge protection status of the original vault."""


class DimensionProperties(_Model):
    """Type of operation: get, read, delete, etc.

    :ivar name: Name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Property to specify whether the dimension should be exported
     for Shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of dimension."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of dimension."""
    to_be_exported_for_shoebox: Optional[bool] = rest_field(
        name="toBeExportedForShoebox", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the dimension should be exported for Shoebox."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The server error.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The inner error, contains a more specific error code.
    :vartype inner_error: ~azure.mgmt.keyvault.models.Error
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    inner_error: Optional["_models.Error"] = rest_field(name="innererror", visibility=["read"])
    """The inner error, contains a more specific error code."""


class IPRule(_Model):
    """A rule governing the accessibility of a vault from a specific ip address or ip range.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or
     '124.56.78.0/24' (all addresses that start with 124.56.78). Required."""

    @overload
    def __init__(
        self,
        *,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Key(ProxyResource):
    """The key resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: The properties of the key. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.KeyProperties
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: "_models.KeyProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The properties of the key. Required."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The supported Azure location where the managed HSM Pool should be created."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Resource tags."""

    __flattened_items = [
        "attributes",
        "kty",
        "key_ops",
        "key_size",
        "curve_name",
        "key_uri",
        "key_uri_with_version",
        "rotation_policy",
        "release_policy",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.KeyProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class KeyAttributes(_Model):
    """The object attributes managed by the Azure Key Vault service.

    :ivar enabled: Determines whether or not the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :vartype not_before: int
    :ivar expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :vartype expires: int
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: int
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: int
    :ivar recovery_level: The deletion recovery level currently in effect for the object. If it
     contains 'Purgeable', then the object can be permanently deleted by a privileged user;
     otherwise, only the system can purge the object at the end of the retention interval. Known
     values are: "Purgeable", "Recoverable+Purgeable", "Recoverable", and
     "Recoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.mgmt.keyvault.models.DeletionRecoveryLevel
    :ivar exportable: Indicates if the private key can be exported.
    :vartype exportable: bool
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Determines whether or not the object is enabled."""
    not_before: Optional[int] = rest_field(name="nbf", visibility=["read", "create", "update", "delete", "query"])
    """Not before date in seconds since 1970-01-01T00:00:00Z."""
    expires: Optional[int] = rest_field(name="exp", visibility=["read", "create", "update", "delete", "query"])
    """Expiry date in seconds since 1970-01-01T00:00:00Z."""
    created: Optional[int] = rest_field(visibility=["read"])
    """Creation time in seconds since 1970-01-01T00:00:00Z."""
    updated: Optional[int] = rest_field(visibility=["read"])
    """Last updated time in seconds since 1970-01-01T00:00:00Z."""
    recovery_level: Optional[Union[str, "_models.DeletionRecoveryLevel"]] = rest_field(
        name="recoveryLevel", visibility=["read"]
    )
    """The deletion recovery level currently in effect for the object. If it contains 'Purgeable',
     then the object can be permanently deleted by a privileged user; otherwise, only the system can
     purge the object at the end of the retention interval. Known values are: \"Purgeable\",
     \"Recoverable+Purgeable\", \"Recoverable\", and \"Recoverable+ProtectedSubscription\"."""
    exportable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates if the private key can be exported."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[int] = None,
        expires: Optional[int] = None,
        exportable: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyCreateParameters(_Model):
    """The parameters used to create a key.

    :ivar tags: The tags that will be assigned to the key.
    :vartype tags: dict[str, str]
    :ivar properties: The properties of the key to be created. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.KeyProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the key."""
    properties: "_models.KeyProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The properties of the key to be created. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.KeyProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyProperties(_Model):
    """The properties of the key.

    :ivar attributes: The attributes of the key.
    :vartype attributes: ~azure.mgmt.keyvault.models.KeyAttributes
    :ivar kty: The type of the key. For valid values, see JsonWebKeyType. Known values are: "EC",
     "EC-HSM", "RSA", and "RSA-HSM".
    :vartype kty: str or ~azure.mgmt.keyvault.models.JsonWebKeyType
    :ivar key_ops:
    :vartype key_ops: list[str or ~azure.mgmt.keyvault.models.JsonWebKeyOperation]
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA. Default for RSA
     and RSA-HSM keys is 2048. Exception made for bring your own key (BYOK), key exchange keys
     default to 4096.
    :vartype key_size: int
    :ivar curve_name: The elliptic curve name. For valid values, see JsonWebKeyCurveName. Default
     for EC and EC-HSM keys is P-256. Known values are: "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve_name: str or ~azure.mgmt.keyvault.models.JsonWebKeyCurveName
    :ivar key_uri: The URI to retrieve the current version of the key.
    :vartype key_uri: str
    :ivar key_uri_with_version: The URI to retrieve the specific version of the key.
    :vartype key_uri_with_version: str
    :ivar rotation_policy: Key rotation policy in response. It will be used for both output and
     input. Omitted if empty.
    :vartype rotation_policy: ~azure.mgmt.keyvault.models.RotationPolicy
    :ivar release_policy: Key release policy in response. It will be used for both output and
     input. Omitted if empty.
    :vartype release_policy: ~azure.mgmt.keyvault.models.KeyReleasePolicy
    """

    attributes: Optional["_models.KeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of the key."""
    kty: Optional[Union[str, "_models.JsonWebKeyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the key. For valid values, see JsonWebKeyType. Known values are: \"EC\",
     \"EC-HSM\", \"RSA\", and \"RSA-HSM\"."""
    key_ops: Optional[list[Union[str, "_models.JsonWebKeyOperation"]]] = rest_field(
        name="keyOps", visibility=["read", "create", "update", "delete", "query"]
    )
    key_size: Optional[int] = rest_field(name="keySize", visibility=["read", "create", "update", "delete", "query"])
    """The key size in bits. For example: 2048, 3072, or 4096 for RSA. Default for RSA and RSA-HSM
     keys is 2048. Exception made for bring your own key (BYOK), key exchange keys default to 4096."""
    curve_name: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = rest_field(
        name="curveName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elliptic curve name. For valid values, see JsonWebKeyCurveName. Default for EC and EC-HSM
     keys is P-256. Known values are: \"P-256\", \"P-384\", \"P-521\", and \"P-256K\"."""
    key_uri: Optional[str] = rest_field(name="keyUri", visibility=["read"])
    """The URI to retrieve the current version of the key."""
    key_uri_with_version: Optional[str] = rest_field(name="keyUriWithVersion", visibility=["read"])
    """The URI to retrieve the specific version of the key."""
    rotation_policy: Optional["_models.RotationPolicy"] = rest_field(
        name="rotationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key rotation policy in response. It will be used for both output and input. Omitted if empty."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Key release policy in response. It will be used for both output and input. Omitted if empty."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional["_models.KeyAttributes"] = None,
        kty: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_ops: Optional[list[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_size: Optional[int] = None,
        curve_name: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        rotation_policy: Optional["_models.RotationPolicy"] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyReleasePolicy(_Model):
    """KeyReleasePolicy.

    :ivar content_type: Content type and version of key release policy.
    :vartype content_type: str
    :ivar data: Blob encoding the policy rules under which the key can be released.
    :vartype data: bytes
    """

    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Content type and version of key release policy."""
    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Blob encoding the policy rules under which the key can be released."""

    @overload
    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        data: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyRotationPolicyAttributes(_Model):
    """KeyRotationPolicyAttributes.

    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: int
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: int
    :ivar expiry_time: The expiration time for the new key version. It should be in ISO8601 format.
     Eg: 'P90D', 'P1Y'.
    :vartype expiry_time: str
    """

    created: Optional[int] = rest_field(visibility=["read"])
    """Creation time in seconds since 1970-01-01T00:00:00Z."""
    updated: Optional[int] = rest_field(visibility=["read"])
    """Last updated time in seconds since 1970-01-01T00:00:00Z."""
    expiry_time: Optional[str] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'."""

    @overload
    def __init__(
        self,
        *,
        expiry_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LifetimeAction(_Model):
    """LifetimeAction.

    :ivar trigger: The trigger of key rotation policy lifetimeAction.
    :vartype trigger: ~azure.mgmt.keyvault.models.Trigger
    :ivar action: The action of key rotation policy lifetimeAction.
    :vartype action: ~azure.mgmt.keyvault.models.Action
    """

    trigger: Optional["_models.Trigger"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The trigger of key rotation policy lifetimeAction."""
    action: Optional["_models.Action"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The action of key rotation policy lifetimeAction."""

    @overload
    def __init__(
        self,
        *,
        trigger: Optional["_models.Trigger"] = None,
        action: Optional["_models.Action"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogSpecification(_Model):
    """Log specification of operation.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of specification.
    :vartype blob_duration: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of log specification."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of log specification."""
    blob_duration: Optional[str] = rest_field(
        name="blobDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Blob duration of specification."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsm(Resource):
    """Resource information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Properties of the managed HSM.
    :vartype properties: ~azure.mgmt.keyvault.models.ManagedHsmProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.models.ManagedHsmSku
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.keyvault.models.ManagedServiceIdentity
    """

    properties: Optional["_models.ManagedHsmProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the managed HSM."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""
    sku: Optional["_models.ManagedHsmSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ManagedHsmProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmAction(_Model):
    """ManagedHsmAction.

    :ivar type: The type of action. Known values are: "rotate" and "notify".
    :vartype type: str or ~azure.mgmt.keyvault.models.KeyRotationPolicyActionType
    """

    type: Optional[Union[str, "_models.KeyRotationPolicyActionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of action. Known values are: \"rotate\" and \"notify\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.KeyRotationPolicyActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmError(_Model):
    """The error exception.

    :ivar error: The server error.
    :vartype error: ~azure.mgmt.keyvault.models.Error
    """

    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """The server error."""


class ManagedHsmKey(ProxyResource):
    """The key resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: The properties of the key. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.ManagedHsmKeyProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: "_models.ManagedHsmKeyProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the key. Required."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Resource tags."""

    __flattened_items = [
        "attributes",
        "kty",
        "key_ops",
        "key_size",
        "curve_name",
        "key_uri",
        "key_uri_with_version",
        "rotation_policy",
        "release_policy",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.ManagedHsmKeyProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ManagedHsmKeyAttributes(_Model):
    """The object attributes managed by the Azure Key Vault service.

    :ivar enabled: Determines whether or not the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :vartype not_before: int
    :ivar expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :vartype expires: int
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: int
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: int
    :ivar recovery_level: The deletion recovery level currently in effect for the object. If it
     contains 'Purgeable', then the object can be permanently deleted by a privileged user;
     otherwise, only the system can purge the object at the end of the retention interval. Known
     values are: "Purgeable", "Recoverable+Purgeable", "Recoverable", and
     "Recoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.mgmt.keyvault.models.DeletionRecoveryLevel
    :ivar exportable: Indicates if the private key can be exported.
    :vartype exportable: bool
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Determines whether or not the object is enabled."""
    not_before: Optional[int] = rest_field(name="nbf", visibility=["read", "create", "update", "delete", "query"])
    """Not before date in seconds since 1970-01-01T00:00:00Z."""
    expires: Optional[int] = rest_field(name="exp", visibility=["read", "create", "update", "delete", "query"])
    """Expiry date in seconds since 1970-01-01T00:00:00Z."""
    created: Optional[int] = rest_field(visibility=["read"])
    """Creation time in seconds since 1970-01-01T00:00:00Z."""
    updated: Optional[int] = rest_field(visibility=["read"])
    """Last updated time in seconds since 1970-01-01T00:00:00Z."""
    recovery_level: Optional[Union[str, "_models.DeletionRecoveryLevel"]] = rest_field(
        name="recoveryLevel", visibility=["read"]
    )
    """The deletion recovery level currently in effect for the object. If it contains 'Purgeable',
     then the object can be permanently deleted by a privileged user; otherwise, only the system can
     purge the object at the end of the retention interval. Known values are: \"Purgeable\",
     \"Recoverable+Purgeable\", \"Recoverable\", and \"Recoverable+ProtectedSubscription\"."""
    exportable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates if the private key can be exported."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[int] = None,
        expires: Optional[int] = None,
        exportable: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmKeyCreateParameters(_Model):
    """The parameters used to create a key.

    :ivar tags: The tags that will be assigned to the key.
    :vartype tags: dict[str, str]
    :ivar properties: The properties of the key to be created. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.ManagedHsmKeyProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the key."""
    properties: "_models.ManagedHsmKeyProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the key to be created. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.ManagedHsmKeyProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmKeyProperties(_Model):
    """The properties of the key.

    :ivar attributes: The attributes of the key.
    :vartype attributes: ~azure.mgmt.keyvault.models.ManagedHsmKeyAttributes
    :ivar kty: The type of the key. For valid values, see JsonWebKeyType. Known values are: "EC",
     "EC-HSM", "RSA", and "RSA-HSM".
    :vartype kty: str or ~azure.mgmt.keyvault.models.JsonWebKeyType
    :ivar key_ops:
    :vartype key_ops: list[str or ~azure.mgmt.keyvault.models.JsonWebKeyOperation]
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA. Default for RSA
     and RSA-HSM keys is 2048. Exception made for bring your own key (BYOK), key exchange keys
     default to 4096.
    :vartype key_size: int
    :ivar curve_name: The elliptic curve name. For valid values, see JsonWebKeyCurveName. Default
     for EC and EC-HSM keys is P-256. Known values are: "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve_name: str or ~azure.mgmt.keyvault.models.JsonWebKeyCurveName
    :ivar key_uri: The URI to retrieve the current version of the key.
    :vartype key_uri: str
    :ivar key_uri_with_version: The URI to retrieve the specific version of the key.
    :vartype key_uri_with_version: str
    :ivar rotation_policy: Key rotation policy in response. It will be used for both output and
     input. Omitted if empty.
    :vartype rotation_policy: ~azure.mgmt.keyvault.models.ManagedHsmRotationPolicy
    :ivar release_policy: Key release policy in response. It will be used for both output and
     input. Omitted if empty.
    :vartype release_policy: ~azure.mgmt.keyvault.models.ManagedHsmKeyReleasePolicy
    """

    attributes: Optional["_models.ManagedHsmKeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of the key."""
    kty: Optional[Union[str, "_models.JsonWebKeyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the key. For valid values, see JsonWebKeyType. Known values are: \"EC\",
     \"EC-HSM\", \"RSA\", and \"RSA-HSM\"."""
    key_ops: Optional[list[Union[str, "_models.JsonWebKeyOperation"]]] = rest_field(
        name="keyOps", visibility=["read", "create", "update", "delete", "query"]
    )
    key_size: Optional[int] = rest_field(name="keySize", visibility=["read", "create", "update", "delete", "query"])
    """The key size in bits. For example: 2048, 3072, or 4096 for RSA. Default for RSA and RSA-HSM
     keys is 2048. Exception made for bring your own key (BYOK), key exchange keys default to 4096."""
    curve_name: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = rest_field(
        name="curveName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elliptic curve name. For valid values, see JsonWebKeyCurveName. Default for EC and EC-HSM
     keys is P-256. Known values are: \"P-256\", \"P-384\", \"P-521\", and \"P-256K\"."""
    key_uri: Optional[str] = rest_field(name="keyUri", visibility=["read"])
    """The URI to retrieve the current version of the key."""
    key_uri_with_version: Optional[str] = rest_field(name="keyUriWithVersion", visibility=["read"])
    """The URI to retrieve the specific version of the key."""
    rotation_policy: Optional["_models.ManagedHsmRotationPolicy"] = rest_field(
        name="rotationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key rotation policy in response. It will be used for both output and input. Omitted if empty."""
    release_policy: Optional["_models.ManagedHsmKeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Key release policy in response. It will be used for both output and input. Omitted if empty."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional["_models.ManagedHsmKeyAttributes"] = None,
        kty: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_ops: Optional[list[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_size: Optional[int] = None,
        curve_name: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        rotation_policy: Optional["_models.ManagedHsmRotationPolicy"] = None,
        release_policy: Optional["_models.ManagedHsmKeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmKeyReleasePolicy(_Model):
    """ManagedHsmKeyReleasePolicy.

    :ivar content_type: Content type and version of key release policy.
    :vartype content_type: str
    :ivar data: Blob encoding the policy rules under which the key can be released.
    :vartype data: bytes
    """

    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Content type and version of key release policy."""
    data: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Blob encoding the policy rules under which the key can be released."""

    @overload
    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        data: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmKeyRotationPolicyAttributes(_Model):
    """ManagedHsmKeyRotationPolicyAttributes.

    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: int
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: int
    :ivar expiry_time: The expiration time for the new key version. It should be in ISO8601 format.
     Eg: 'P90D', 'P1Y'.
    :vartype expiry_time: str
    """

    created: Optional[int] = rest_field(visibility=["read"])
    """Creation time in seconds since 1970-01-01T00:00:00Z."""
    updated: Optional[int] = rest_field(visibility=["read"])
    """Last updated time in seconds since 1970-01-01T00:00:00Z."""
    expiry_time: Optional[str] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'."""

    @overload
    def __init__(
        self,
        *,
        expiry_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmLifetimeAction(_Model):
    """ManagedHsmLifetimeAction.

    :ivar trigger: The trigger of key rotation policy lifetimeAction.
    :vartype trigger: ~azure.mgmt.keyvault.models.ManagedHsmTrigger
    :ivar action: The action of key rotation policy lifetimeAction.
    :vartype action: ~azure.mgmt.keyvault.models.ManagedHsmAction
    """

    trigger: Optional["_models.ManagedHsmTrigger"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The trigger of key rotation policy lifetimeAction."""
    action: Optional["_models.ManagedHsmAction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action of key rotation policy lifetimeAction."""

    @overload
    def __init__(
        self,
        *,
        trigger: Optional["_models.ManagedHsmTrigger"] = None,
        action: Optional["_models.ManagedHsmAction"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmProperties(_Model):
    """Properties of the managed HSM Pool.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the managed HSM pool.
    :vartype tenant_id: str
    :ivar initial_admin_object_ids: Array of initial administrators object ids for this managed hsm
     pool.
    :vartype initial_admin_object_ids: list[str]
    :ivar hsm_uri: The URI of the managed hsm pool for performing operations on keys.
    :vartype hsm_uri: str
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and
     is immutable.
    :vartype enable_soft_delete: bool
    :ivar soft_delete_retention_in_days: Soft deleted data retention days. When you delete an HSM
     or a key, it will remain recoverable for the configured retention period or for a default
     period of 90 days. It accepts values between 7 and 90.
    :vartype soft_delete_retention_in_days: int
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this managed HSM pool. Setting this property to true activates protection against purge for
     this managed HSM pool and its content - only the Managed HSM service may initiate a hard,
     irrecoverable deletion. Enabling this functionality is irreversible.
    :vartype enable_purge_protection: bool
    :ivar create_mode: The create mode to indicate whether the resource is being created or is
     being recovered from a deleted resource. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.models.CreateMode
    :ivar status_message: Resource Status Message.
    :vartype status_message: str
    :ivar provisioning_state: Provisioning state. Known values are: "Succeeded", "Provisioning",
     "Failed", "Updating", "Deleting", "Activated", "SecurityDomainRestore", and "Restoring".
    :vartype provisioning_state: str or ~azure.mgmt.keyvault.models.ProvisioningState
    :ivar network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.keyvault.models.MHSMNetworkRuleSet
    :ivar regions: List of all regions associated with the managed hsm pool.
    :vartype regions: list[~azure.mgmt.keyvault.models.MHSMGeoReplicatedRegion]
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     managed hsm pool.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.models.MHSMPrivateEndpointConnectionItem]
    :ivar public_network_access: Control permission to the managed HSM from public networks. Known
     values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.keyvault.models.PublicNetworkAccess
    :ivar scheduled_purge_date: The scheduled purge date in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar security_domain_properties: Managed HSM security domain properties.
    :vartype security_domain_properties:
     ~azure.mgmt.keyvault.models.ManagedHSMSecurityDomainProperties
    """

    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the
     managed HSM pool."""
    initial_admin_object_ids: Optional[list[str]] = rest_field(
        name="initialAdminObjectIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of initial administrators object ids for this managed hsm pool."""
    hsm_uri: Optional[str] = rest_field(name="hsmUri", visibility=["read"])
    """The URI of the managed hsm pool for performing operations on keys."""
    enable_soft_delete: Optional[bool] = rest_field(
        name="enableSoftDelete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the 'soft delete' functionality is enabled for this managed HSM
     pool. Soft delete is enabled by default for all managed HSMs and is immutable."""
    soft_delete_retention_in_days: Optional[int] = rest_field(
        name="softDeleteRetentionInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable
     for the configured retention period or for a default period of 90 days. It accepts values
     between 7 and 90."""
    enable_purge_protection: Optional[bool] = rest_field(
        name="enablePurgeProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying whether protection against purge is enabled for this managed HSM pool.
     Setting this property to true activates protection against purge for this managed HSM pool and
     its content - only the Managed HSM service may initiate a hard, irrecoverable deletion.
     Enabling this functionality is irreversible."""
    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(
        name="createMode", visibility=["create", "update"]
    )
    """The create mode to indicate whether the resource is being created or is being recovered from a
     deleted resource. Known values are: \"recover\" and \"default\"."""
    status_message: Optional[str] = rest_field(name="statusMessage", visibility=["read"])
    """Resource Status Message."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state. Known values are: \"Succeeded\", \"Provisioning\", \"Failed\",
     \"Updating\", \"Deleting\", \"Activated\", \"SecurityDomainRestore\", and \"Restoring\"."""
    network_acls: Optional["_models.MHSMNetworkRuleSet"] = rest_field(
        name="networkAcls", visibility=["read", "create", "update", "delete", "query"]
    )
    """Rules governing the accessibility of the key vault from specific network locations."""
    regions: Optional[list["_models.MHSMGeoReplicatedRegion"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of all regions associated with the managed hsm pool."""
    private_endpoint_connections: Optional[list["_models.MHSMPrivateEndpointConnectionItem"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections associated with the managed hsm pool."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Control permission to the managed HSM from public networks. Known values are: \"Enabled\" and
     \"Disabled\"."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="rfc3339"
    )
    """The scheduled purge date in UTC."""
    security_domain_properties: Optional["_models.ManagedHSMSecurityDomainProperties"] = rest_field(
        name="securityDomainProperties", visibility=["read"]
    )
    """Managed HSM security domain properties."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        initial_admin_object_ids: Optional[list[str]] = None,
        enable_soft_delete: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        enable_purge_protection: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        network_acls: Optional["_models.MHSMNetworkRuleSet"] = None,
        regions: Optional[list["_models.MHSMGeoReplicatedRegion"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmResource(_Model):
    """Managed HSM resource.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.keyvault.models.ManagedServiceIdentity
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The Azure Resource Manager resource ID for the managed HSM Pool."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the managed HSM Pool."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The resource type of the managed HSM Pool."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The supported Azure location where the managed HSM Pool should be created."""
    sku: Optional["_models.ManagedHsmSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Metadata pertaining to creation and last modification of the key vault resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity (system assigned and/or user assigned identities)."""

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmRotationPolicy(_Model):
    """ManagedHsmRotationPolicy.

    :ivar attributes: The attributes of key rotation policy.
    :vartype attributes: ~azure.mgmt.keyvault.models.ManagedHsmKeyRotationPolicyAttributes
    :ivar lifetime_actions: The lifetimeActions for key rotation action.
    :vartype lifetime_actions: list[~azure.mgmt.keyvault.models.ManagedHsmLifetimeAction]
    """

    attributes: Optional["_models.ManagedHsmKeyRotationPolicyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of key rotation policy."""
    lifetime_actions: Optional[list["_models.ManagedHsmLifetimeAction"]] = rest_field(
        name="lifetimeActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The lifetimeActions for key rotation action."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional["_models.ManagedHsmKeyRotationPolicyAttributes"] = None,
        lifetime_actions: Optional[list["_models.ManagedHsmLifetimeAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHSMSecurityDomainProperties(_Model):
    """The security domain properties of the managed hsm.

    :ivar activation_status: Activation Status. Known values are: "Active", "NotActivated",
     "Unknown", and "Failed".
    :vartype activation_status: str or ~azure.mgmt.keyvault.models.ActivationStatus
    :ivar activation_status_message: Activation Status Message.
    :vartype activation_status_message: str
    """

    activation_status: Optional[Union[str, "_models.ActivationStatus"]] = rest_field(
        name="activationStatus", visibility=["read"]
    )
    """Activation Status. Known values are: \"Active\", \"NotActivated\", \"Unknown\", and \"Failed\"."""
    activation_status_message: Optional[str] = rest_field(name="activationStatusMessage", visibility=["read"])
    """Activation Status Message."""


class ManagedHsmSku(_Model):
    """SKU details.

    :ivar family: SKU Family of the managed HSM Pool. Required. Known values are: "B" and "C".
    :vartype family: str or ~azure.mgmt.keyvault.models.ManagedHsmSkuFamily
    :ivar name: SKU of the managed HSM Pool. Required. Known values are: "Standard_B1",
     "Custom_B32", "Custom_B6", "Custom_C42", and "Custom_C10".
    :vartype name: str or ~azure.mgmt.keyvault.models.ManagedHsmSkuName
    """

    family: Union[str, "_models.ManagedHsmSkuFamily"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """SKU Family of the managed HSM Pool. Required. Known values are: \"B\" and \"C\"."""
    name: Union[str, "_models.ManagedHsmSkuName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """SKU of the managed HSM Pool. Required. Known values are: \"Standard_B1\", \"Custom_B32\",
     \"Custom_B6\", \"Custom_C42\", and \"Custom_C10\"."""

    @overload
    def __init__(
        self,
        *,
        family: Union[str, "_models.ManagedHsmSkuFamily"],
        name: Union[str, "_models.ManagedHsmSkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedHsmTrigger(_Model):
    """ManagedHsmTrigger.

    :ivar time_after_create: The time duration after key creation to rotate the key. It only
     applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
    :vartype time_after_create: str
    :ivar time_before_expiry: The time duration before key expiring to rotate or notify. It will be
     in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
    :vartype time_before_expiry: str
    """

    time_after_create: Optional[str] = rest_field(
        name="timeAfterCreate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time duration after key creation to rotate the key. It only applies to rotate. It will be
     in ISO 8601 duration format. Eg: 'P90D', 'P1Y'."""
    time_before_expiry: Optional[str] = rest_field(
        name="timeBeforeExpiry", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration
     format. Eg: 'P90D', 'P1Y'."""

    @overload
    def __init__(
        self,
        *,
        time_after_create: Optional[str] = None,
        time_before_expiry: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.keyvault.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.keyvault.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricSpecification(_Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
    :vartype unit: str
    :ivar aggregation_type: The metric aggregation type. Possible values include: 'Average',
     'Count', 'Total'.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: The supported aggregation types for the metrics.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar lock_aggregation_type: The metric lock aggregation type.
    :vartype lock_aggregation_type: str
    :ivar dimensions: The dimensions of metric.
    :vartype dimensions: list[~azure.mgmt.keyvault.models.DimensionProperties]
    :ivar fill_gap_with_zero: Property to specify whether to fill gap with zero.
    :vartype fill_gap_with_zero: bool
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of metric specification."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of metric specification."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display description of metric specification."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'."""
    aggregation_type: Optional[str] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'."""
    supported_aggregation_types: Optional[list[str]] = rest_field(
        name="supportedAggregationTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The supported aggregation types for the metrics."""
    supported_time_grain_types: Optional[list[str]] = rest_field(
        name="supportedTimeGrainTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The supported time grain types for the metrics."""
    lock_aggregation_type: Optional[str] = rest_field(
        name="lockAggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The metric lock aggregation type."""
    dimensions: Optional[list["_models.DimensionProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The dimensions of metric."""
    fill_gap_with_zero: Optional[bool] = rest_field(
        name="fillGapWithZero", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether to fill gap with zero."""
    internal_metric_name: Optional[str] = rest_field(
        name="internalMetricName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The internal metric name."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[list[str]] = None,
        supported_time_grain_types: Optional[list[str]] = None,
        lock_aggregation_type: Optional[str] = None,
        dimensions: Optional[list["_models.DimensionProperties"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        internal_metric_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMGeoReplicatedRegion(_Model):
    """A region that this managed HSM Pool has been extended to.

    :ivar name: Name of the geo replicated region.
    :vartype name: str
    :ivar provisioning_state: Provisioning state of the geo replicated region. Known values are:
     "Preprovisioning", "Provisioning", "Succeeded", "Failed", "Deleting", and "Cleanup".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.models.GeoReplicationRegionProvisioningState
    :ivar is_primary: A boolean value that indicates whether the region is the primary region or a
     secondary region.
    :vartype is_primary: bool
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the geo replicated region."""
    provisioning_state: Optional[Union[str, "_models.GeoReplicationRegionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the geo replicated region. Known values are: \"Preprovisioning\",
     \"Provisioning\", \"Succeeded\", \"Failed\", \"Deleting\", and \"Cleanup\"."""
    is_primary: Optional[bool] = rest_field(
        name="isPrimary", visibility=["read", "create", "update", "delete", "query"]
    )
    """A boolean value that indicates whether the region is the primary region or a secondary region."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_primary: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMIPRule(_Model):
    """A rule governing the accessibility of a managed HSM pool from a specific IP address or IP
    range.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or
     '124.56.78.0/24' (all addresses that start with 124.56.78). Required."""

    @overload
    def __init__(
        self,
        *,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMNetworkRuleSet(_Model):
    """A set of rules governing the network accessibility of a managed hsm pool.

    :ivar bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
     "None".
    :vartype bypass: str or ~azure.mgmt.keyvault.models.NetworkRuleBypassOptions
    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.keyvault.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.keyvault.models.MHSMIPRule]
    :ivar service_tags: The list of service tags.
    :vartype service_tags: list[~azure.mgmt.keyvault.models.MHSMServiceTagRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.keyvault.models.MHSMVirtualNetworkRule]
    """

    bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not
     specified the default is 'AzureServices'. Known values are: \"AzureServices\" and \"None\"."""
    default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = rest_field(
        name="defaultAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The default action when no rule from ipRules and from virtualNetworkRules match. This is only
     used after the bypass property has been evaluated. Known values are: \"Allow\" and \"Deny\"."""
    ip_rules: Optional[list["_models.MHSMIPRule"]] = rest_field(
        name="ipRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of IP address rules."""
    service_tags: Optional[list["_models.MHSMServiceTagRule"]] = rest_field(
        name="serviceTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of service tags."""
    virtual_network_rules: Optional[list["_models.MHSMVirtualNetworkRule"]] = rest_field(
        name="virtualNetworkRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of virtual network rules."""

    @overload
    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[list["_models.MHSMIPRule"]] = None,
        service_tags: Optional[list["_models.MHSMServiceTagRule"]] = None,
        virtual_network_rules: Optional[list["_models.MHSMVirtualNetworkRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMPrivateEndpoint(_Model):
    """Private endpoint object properties.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Full identifier of the private endpoint resource."""


class MHSMPrivateEndpointConnection(Resource):
    """Private endpoint connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.keyvault.models.MHSMPrivateEndpointConnectionProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.models.ManagedHsmSku
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.keyvault.models.ManagedServiceIdentity
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    """

    properties: Optional["_models.MHSMPrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""
    sku: Optional["_models.ManagedHsmSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modified whenever there is a change in the state of private endpoint connection."""

    __flattened_items = ["private_endpoint", "private_link_service_connection_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.MHSMPrivateEndpointConnectionProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MHSMPrivateEndpointConnectionItem(_Model):
    """Private endpoint connection item.

    :ivar id: Id of private endpoint connection.
    :vartype id: str
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.keyvault.models.MHSMPrivateEndpointConnectionProperties
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Id of private endpoint connection."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modified whenever there is a change in the state of private endpoint connection."""
    properties: Optional["_models.MHSMPrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Private endpoint connection properties."""

    __flattened_items = ["private_endpoint", "private_link_service_connection_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        etag: Optional[str] = None,
        properties: Optional["_models.MHSMPrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MHSMPrivateEndpointConnectionProperties(_Model):
    """Properties of the private endpoint connection resource.

    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.models.MHSMPrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.models.MHSMPrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.models.PrivateEndpointConnectionProvisioningState
    """

    private_endpoint: Optional["_models.MHSMPrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the private endpoint object."""
    private_link_service_connection_state: Optional["_models.MHSMPrivateLinkServiceConnectionState"] = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval state of the private link connection."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the private endpoint connection. Known values are: \"Succeeded\",
     \"Creating\", \"Updating\", \"Deleting\", \"Failed\", and \"Disconnected\"."""

    @overload
    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.MHSMPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.MHSMPrivateLinkServiceConnectionState"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMPrivateLinkResource(ManagedHsmResource):
    """A private link resource.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :ivar location: The supported Azure location where the managed HSM Pool should be created.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.models.ManagedHsmSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.keyvault.models.ManagedServiceIdentity
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.keyvault.models.MHSMPrivateLinkResourceProperties
    """

    properties: Optional["_models.MHSMPrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["_models.ManagedHsmSku"] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        properties: Optional["_models.MHSMPrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class MHSMPrivateLinkResourceListResult(_Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.keyvault.models.MHSMPrivateLinkResource]
    """

    value: Optional[list["_models.MHSMPrivateLinkResource"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of private link resources."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.MHSMPrivateLinkResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMPrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """Group identifier of private link resource."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """Required member names of private link resource."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required DNS zone names of the the private link resource."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMPrivateLinkServiceConnectionState(_Model):
    """An object that represents the approval state of the private link connection.

    :ivar status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.keyvault.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval or rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. "None"
    :vartype actions_required: str or ~azure.mgmt.keyvault.models.ActionsRequired
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     Known values are: \"Pending\", \"Approved\", \"Rejected\", and \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval or rejection."""
    actions_required: Optional[Union[str, "_models.ActionsRequired"]] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer.
     \"None\""""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMServiceTagRule(_Model):
    """A rule governing the accessibility of a managed hsm pool from a specific service tags.

    :ivar tag: Name of the service tag. Required.
    :vartype tag: str
    """

    tag: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the service tag. Required."""

    @overload
    def __init__(
        self,
        *,
        tag: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MHSMVirtualNetworkRule(_Model):
    """A rule governing the accessibility of a managed hsm pool from a specific virtual network.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkRuleSet(_Model):
    """A set of rules governing the network accessibility of a vault.

    :ivar bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Known values are: "AzureServices" and
     "None".
    :vartype bypass: str or ~azure.mgmt.keyvault.models.NetworkRuleBypassOptions
    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.keyvault.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.keyvault.models.IPRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.keyvault.models.VirtualNetworkRule]
    """

    bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not
     specified the default is 'AzureServices'. Known values are: \"AzureServices\" and \"None\"."""
    default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = rest_field(
        name="defaultAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The default action when no rule from ipRules and from virtualNetworkRules match. This is only
     used after the bypass property has been evaluated. Known values are: \"Allow\" and \"Deny\"."""
    ip_rules: Optional[list["_models.IPRule"]] = rest_field(
        name="ipRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of IP address rules."""
    virtual_network_rules: Optional[list["_models.VirtualNetworkRule"]] = rest_field(
        name="virtualNetworkRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of virtual network rules."""

    @overload
    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[list["_models.IPRule"]] = None,
        virtual_network_rules: Optional[list["_models.VirtualNetworkRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Key Vault REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.keyvault.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar operation_properties: Properties of operation, include metric specifications.
    :vartype operation_properties: ~azure.mgmt.keyvault.models.OperationProperties
    :ivar is_data_action: Property to specify whether the action is a data action.
    :vartype is_data_action: bool
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation name: {provider}/{resource}/{operation}."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Display metadata associated with the operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The origin of operations."""
    operation_properties: Optional["_models.OperationProperties"] = rest_field(
        name="properties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of operation, include metric specifications."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the action is a data action."""

    __flattened_items = ["service_specification"]

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        operation_properties: Optional["_models.OperationProperties"] = None,
        is_data_action: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.operation_properties is None:
                return None
            return getattr(self.operation_properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.operation_properties is None:
                self.operation_properties = self._attr_to_rest_field["operation_properties"]._class_type()
            setattr(self.operation_properties, key, value)
        else:
            super().__setattr__(key, value)


class OperationDisplay(_Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Key Vault.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of operation.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Service provider: Microsoft Key Vault."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource on which the operation is performed etc."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of operation: get, read, delete, etc."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of operation."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationProperties(_Model):
    """Properties of operation, include metric specifications.

    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.keyvault.models.ServiceSpecification
    """

    service_specification: Optional["_models.ServiceSpecification"] = rest_field(
        name="serviceSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """One property of operation, include metric specifications."""

    @overload
    def __init__(
        self,
        *,
        service_specification: Optional["_models.ServiceSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Permissions(_Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :ivar keys_property: Permissions to keys.
    :vartype keys_property: list[str or ~azure.mgmt.keyvault.models.KeyPermissions]
    :ivar secrets: Permissions to secrets.
    :vartype secrets: list[str or ~azure.mgmt.keyvault.models.SecretPermissions]
    :ivar certificates: Permissions to certificates.
    :vartype certificates: list[str or ~azure.mgmt.keyvault.models.CertificatePermissions]
    :ivar storage: Permissions to storage accounts.
    :vartype storage: list[str or ~azure.mgmt.keyvault.models.StoragePermissions]
    """

    keys_property: Optional[list[Union[str, "_models.KeyPermissions"]]] = rest_field(
        name="keys", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="keys"
    )
    """Permissions to keys."""
    secrets: Optional[list[Union[str, "_models.SecretPermissions"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Permissions to secrets."""
    certificates: Optional[list[Union[str, "_models.CertificatePermissions"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Permissions to certificates."""
    storage: Optional[list[Union[str, "_models.StoragePermissions"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Permissions to storage accounts."""

    @overload
    def __init__(
        self,
        *,
        keys_property: Optional[list[Union[str, "_models.KeyPermissions"]]] = None,
        secrets: Optional[list[Union[str, "_models.SecretPermissions"]]] = None,
        certificates: Optional[list[Union[str, "_models.CertificatePermissions"]]] = None,
        storage: Optional[list[Union[str, "_models.StoragePermissions"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """Private endpoint object properties.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Full identifier of the private endpoint resource."""


class PrivateEndpointConnection(ProxyResource):
    """Private endpoint connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.keyvault.models.PrivateEndpointConnectionProperties
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""
    location: Optional[str] = rest_field(visibility=["read"])
    """Azure location of the key vault resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags assigned to the key vault resource."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modified whenever there is a change in the state of private endpoint connection."""

    __flattened_items = ["private_endpoint", "private_link_service_connection_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionItem(_Model):
    """Private endpoint connection item.

    :ivar id: Id of private endpoint connection.
    :vartype id: str
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.keyvault.models.PrivateEndpointConnectionProperties
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Id of private endpoint connection."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modified whenever there is a change in the state of private endpoint connection."""
    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Private endpoint connection properties."""

    __flattened_items = ["private_endpoint", "private_link_service_connection_state", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        etag: Optional[str] = None,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of the private endpoint connection resource.

    :ivar private_endpoint: Properties of the private endpoint object.
    :vartype private_endpoint: ~azure.mgmt.keyvault.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Approval state of the private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.keyvault.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Failed", and "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.models.PrivateEndpointConnectionProvisioningState
    """

    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the private endpoint object."""
    private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval state of the private link connection."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the private endpoint connection. Known values are: \"Succeeded\",
     \"Creating\", \"Updating\", \"Deleting\", \"Failed\", and \"Disconnected\"."""

    @overload
    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.keyvault.models.PrivateLinkResourceProperties
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""
    location: Optional[str] = rest_field(visibility=["read"])
    """Azure location of the key vault resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags assigned to the key vault resource."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceListResult(_Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.keyvault.models.PrivateLinkResource]
    """

    value: Optional[list["_models.PrivateLinkResource"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of private link resources."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[list["_models.PrivateLinkResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """Group identifier of private link resource."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """Required member names of private link resource."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required DNS zone names of the the private link resource."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """An object that represents the approval state of the private link connection.

    :ivar status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.keyvault.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval or rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. "None"
    :vartype actions_required: str or ~azure.mgmt.keyvault.models.ActionsRequired
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been approved, rejected or removed by the key vault owner.
     Known values are: \"Pending\", \"Approved\", \"Rejected\", and \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval or rejection."""
    actions_required: Optional[Union[str, "_models.ActionsRequired"]] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer.
     \"None\""""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RotationPolicy(_Model):
    """RotationPolicy.

    :ivar attributes: The attributes of key rotation policy.
    :vartype attributes: ~azure.mgmt.keyvault.models.KeyRotationPolicyAttributes
    :ivar lifetime_actions: The lifetimeActions for key rotation action.
    :vartype lifetime_actions: list[~azure.mgmt.keyvault.models.LifetimeAction]
    """

    attributes: Optional["_models.KeyRotationPolicyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of key rotation policy."""
    lifetime_actions: Optional[list["_models.LifetimeAction"]] = rest_field(
        name="lifetimeActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The lifetimeActions for key rotation action."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional["_models.KeyRotationPolicyAttributes"] = None,
        lifetime_actions: Optional[list["_models.LifetimeAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Secret(ProxyResource):
    """Resource information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Properties of the secret. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.SecretProperties
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    properties: "_models.SecretProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the secret. Required."""
    location: Optional[str] = rest_field(visibility=["read"])
    """Azure location of the key vault resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags assigned to the key vault resource."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.SecretProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretAttributes(Attributes):
    """The secret management attributes.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: ~datetime.datetime
    """

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretCreateOrUpdateParameters(_Model):
    """Parameters for creating or updating a secret.

    :ivar tags: The tags that will be assigned to the secret.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the secret. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.SecretProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the secret."""
    properties: "_models.SecretProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the secret. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.SecretProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretPatchParameters(_Model):
    """Parameters for patching a secret.

    :ivar tags: The tags that will be assigned to the secret.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the secret.
    :vartype properties: ~azure.mgmt.keyvault.models.SecretPatchProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the secret."""
    properties: Optional["_models.SecretPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the secret."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.SecretPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretPatchProperties(_Model):
    """Properties of the secret.

    :ivar value: The value of the secret.
    :vartype value: str
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The attributes of the secret.
    :vartype attributes: ~azure.mgmt.keyvault.models.SecretAttributes
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the secret."""
    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The content type of the secret."""
    attributes: Optional["_models.SecretAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of the secret."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.SecretAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretProperties(_Model):
    """Properties of the secret.

    :ivar value: The value of the secret. NOTE: 'value' will never be returned from the service, as
     APIs using this model are is intended for internal use in ARM deployments. Users should use the
     data-plane REST service for interaction with vault secrets.
    :vartype value: str
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The attributes of the secret.
    :vartype attributes: ~azure.mgmt.keyvault.models.SecretAttributes
    :ivar secret_uri: The URI to retrieve the current version of the secret.
    :vartype secret_uri: str
    :ivar secret_uri_with_version: The URI to retrieve the specific version of the secret.
    :vartype secret_uri_with_version: str
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using
     this model are is intended for internal use in ARM deployments. Users should use the data-plane
     REST service for interaction with vault secrets."""
    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The content type of the secret."""
    attributes: Optional["_models.SecretAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of the secret."""
    secret_uri: Optional[str] = rest_field(name="secretUri", visibility=["read"])
    """The URI to retrieve the current version of the secret."""
    secret_uri_with_version: Optional[str] = rest_field(name="secretUriWithVersion", visibility=["read"])
    """The URI to retrieve the specific version of the secret."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.SecretAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceSpecification(_Model):
    """One property of operation, include log specifications.

    :ivar log_specifications: Log specifications of operation.
    :vartype log_specifications: list[~azure.mgmt.keyvault.models.LogSpecification]
    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications: list[~azure.mgmt.keyvault.models.MetricSpecification]
    """

    log_specifications: Optional[list["_models.LogSpecification"]] = rest_field(
        name="logSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Log specifications of operation."""
    metric_specifications: Optional[list["_models.MetricSpecification"]] = rest_field(
        name="metricSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Metric specifications of operation."""

    @overload
    def __init__(
        self,
        *,
        log_specifications: Optional[list["_models.LogSpecification"]] = None,
        metric_specifications: Optional[list["_models.MetricSpecification"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """SKU details.

    :ivar family: SKU family name. Required. "A"
    :vartype family: str or ~azure.mgmt.keyvault.models.SkuFamily
    :ivar name: SKU name to specify whether the key vault is a standard vault or a premium vault.
     Required. Known values are: "standard" and "premium".
    :vartype name: str or ~azure.mgmt.keyvault.models.SkuName
    """

    family: Union[str, "_models.SkuFamily"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU family name. Required. \"A\""""
    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU name to specify whether the key vault is a standard vault or a premium vault. Required.
     Known values are: \"standard\" and \"premium\"."""

    @overload
    def __init__(
        self,
        *,
        family: Union[str, "_models.SkuFamily"],
        name: Union[str, "_models.SkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.keyvault.models.IdentityType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.keyvault.models.IdentityType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.IdentityType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Trigger(_Model):
    """Trigger.

    :ivar time_after_create: The time duration after key creation to rotate the key. It only
     applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
    :vartype time_after_create: str
    :ivar time_before_expiry: The time duration before key expiring to rotate or notify. It will be
     in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
    :vartype time_before_expiry: str
    """

    time_after_create: Optional[str] = rest_field(
        name="timeAfterCreate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time duration after key creation to rotate the key. It only applies to rotate. It will be
     in ISO 8601 duration format. Eg: 'P90D', 'P1Y'."""
    time_before_expiry: Optional[str] = rest_field(
        name="timeBeforeExpiry", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration
     format. Eg: 'P90D', 'P1Y'."""

    @overload
    def __init__(
        self,
        *,
        time_after_create: Optional[str] = None,
        time_before_expiry: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class Vault(ProxyResource):
    """Resource information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.keyvault.models.SystemData
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.VaultProperties
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    properties: "_models.VaultProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the vault. Required."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Azure location of the key vault resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tags assigned to the key vault resource."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.VaultProperties",
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultAccessPolicyParameters(_Model):
    """Parameters for updating the access policy in a vault.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :ivar properties: Properties of the access policy. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.VaultAccessPolicyProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource id of the access policy."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The resource name of the access policy."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The resource name of the access policy."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The resource type of the access policy."""
    properties: "_models.VaultAccessPolicyProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the access policy. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.VaultAccessPolicyProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultAccessPolicyProperties(_Model):
    """Properties of the vault access policy.

    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. Required.
    :vartype access_policies: list[~azure.mgmt.keyvault.models.AccessPolicyEntry]
    """

    access_policies: list["_models.AccessPolicyEntry"] = rest_field(
        name="accessPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of 0 to 16 identities that have access to the key vault. All identities in the array
     must use the same tenant ID as the key vault's tenant ID. Required."""

    @overload
    def __init__(
        self,
        *,
        access_policies: list["_models.AccessPolicyEntry"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultCheckNameAvailabilityParameters(_Model):
    """The parameters used to check the availability of the vault name.

    :ivar name: The vault name. Required.
    :vartype name: str
    :ivar type: The type of resource, Microsoft.KeyVault/vaults. Required. Default value is
     "Microsoft.KeyVault/vaults".
    :vartype type: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The vault name. Required."""
    type: Literal["Microsoft.KeyVault/vaults"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of resource, Microsoft.KeyVault/vaults. Required. Default value is
     \"Microsoft.KeyVault/vaults\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["Microsoft.KeyVault/vaults"] = "Microsoft.KeyVault/vaults"


class VaultCreateOrUpdateParameters(_Model):
    """Parameters for creating or updating a vault.

    :ivar location: The supported Azure location where the key vault should be created. Required.
    :vartype location: str
    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault. Required.
    :vartype properties: ~azure.mgmt.keyvault.models.VaultProperties
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The supported Azure location where the key vault should be created. Required."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the key vault."""
    properties: "_models.VaultProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the vault. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.VaultProperties",
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultPatchParameters(_Model):
    """Parameters for creating or updating a vault.

    :ivar tags: The tags that will be assigned to the key vault.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the vault.
    :vartype properties: ~azure.mgmt.keyvault.models.VaultPatchProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags that will be assigned to the key vault."""
    properties: Optional["_models.VaultPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the vault."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VaultPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultPatchProperties(_Model):
    """Properties of the vault.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault.
    :vartype tenant_id: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.keyvault.models.Sku
    :ivar access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID.
    :vartype access_policies: list[~azure.mgmt.keyvault.models.AccessPolicyEntry]
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. Once set to true, it cannot be reverted to false.
    :vartype enable_soft_delete: bool
    :ivar enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored. When false,
     the key vault will use the access policies specified in vault properties, and any policy stored
     on Azure Resource Manager will be ignored. If null or not specified, the value of this property
     will not change.
    :vartype enable_rbac_authorization: bool
    :ivar soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :vartype soft_delete_retention_in_days: int
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: A collection of rules governing the accessibility of the vault from
     specific network locations.
    :vartype network_acls: ~azure.mgmt.keyvault.models.NetworkRuleSet
    :ivar public_network_access: Property to specify whether the vault will accept traffic from
     public internet. If set to 'disabled' all traffic except private endpoint traffic and that that
     originates from trusted services will be blocked. This will override the set firewall rules,
     meaning that even if the firewall rules are present we will not honor the rules.
    :vartype public_network_access: str
    """

    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the key
     vault."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details."""
    access_policies: Optional[list["_models.AccessPolicyEntry"]] = rest_field(
        name="accessPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of 0 to 16 identities that have access to the key vault. All identities in the array
     must use the same tenant ID as the key vault's tenant ID."""
    enabled_for_deployment: Optional[bool] = rest_field(
        name="enabledForDeployment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Virtual Machines are permitted to retrieve certificates
     stored as secrets from the key vault."""
    enabled_for_disk_encryption: Optional[bool] = rest_field(
        name="enabledForDiskEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the
     vault and unwrap keys."""
    enabled_for_template_deployment: Optional[bool] = rest_field(
        name="enabledForTemplateDeployment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the
     key vault."""
    enable_soft_delete: Optional[bool] = rest_field(
        name="enableSoftDelete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once
     set to true, it cannot be reverted to false."""
    enable_rbac_authorization: Optional[bool] = rest_field(
        name="enableRbacAuthorization", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property that controls how data actions are authorized. When true, the key vault will use Role
     Based Access Control (RBAC) for authorization of data actions, and the access policies
     specified in vault properties will be  ignored. When false, the key vault will use the access
     policies specified in vault properties, and any policy stored on Azure Resource Manager will be
     ignored. If null or not specified, the value of this property will not change."""
    soft_delete_retention_in_days: Optional[int] = rest_field(
        name="softDeleteRetentionInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """softDelete data retention days. It accepts >=7 and <=90."""
    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(
        name="createMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The vault's create mode to indicate whether the vault need to be recovered or not. Known values
     are: \"recover\" and \"default\"."""
    enable_purge_protection: Optional[bool] = rest_field(
        name="enablePurgeProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying whether protection against purge is enabled for this vault. Setting this
     property to true activates protection against purge for this vault and its content - only the
     Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if
     soft delete is also enabled. Enabling this functionality is irreversible - that is, the
     property does not accept false as its value."""
    network_acls: Optional["_models.NetworkRuleSet"] = rest_field(
        name="networkAcls", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of rules governing the accessibility of the vault from specific network locations."""
    public_network_access: Optional[str] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the vault will accept traffic from public internet. If set to
     'disabled' all traffic except private endpoint traffic and that that originates from trusted
     services will be blocked. This will override the set firewall rules, meaning that even if the
     firewall rules are present we will not honor the rules."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        access_policies: Optional[list["_models.AccessPolicyEntry"]] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        enable_rbac_authorization: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        public_network_access: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultProperties(_Model):
    """Properties of the vault.

    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault. Required.
    :vartype tenant_id: str
    :ivar sku: SKU details. Required.
    :vartype sku: ~azure.mgmt.keyvault.models.Sku
    :ivar access_policies: An array of 0 to 1024 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. When
     ``createMode`` is set to ``recover``, access policies are not required. Otherwise, access
     policies are required.
    :vartype access_policies: list[~azure.mgmt.keyvault.models.AccessPolicyEntry]
    :ivar vault_uri: The URI of the vault for performing operations on keys and secrets.
    :vartype vault_uri: str
    :ivar hsm_pool_resource_id: The resource id of HSM Pool.
    :vartype hsm_pool_resource_id: str
    :ivar enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :vartype enabled_for_deployment: bool
    :ivar enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :vartype enabled_for_disk_encryption: bool
    :ivar enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :vartype enabled_for_template_deployment: bool
    :ivar enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. If it's not set to any value(true or false) when creating new key
     vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
    :vartype enable_soft_delete: bool
    :ivar soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :vartype soft_delete_retention_in_days: int
    :ivar enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored. When false,
     the key vault will use the access policies specified in vault properties, and any policy stored
     on Azure Resource Manager will be ignored. If null or not specified, the vault is created with
     the default value of false. Note that management actions are always authorized with RBAC.
    :vartype enable_rbac_authorization: bool
    :ivar create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Known values are: "recover" and "default".
    :vartype create_mode: str or ~azure.mgmt.keyvault.models.CreateMode
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :vartype enable_purge_protection: bool
    :ivar network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.keyvault.models.NetworkRuleSet
    :ivar provisioning_state: Provisioning state of the vault. Known values are: "Succeeded" and
     "RegisteringDns".
    :vartype provisioning_state: str or ~azure.mgmt.keyvault.models.VaultProvisioningState
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     key vault.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.models.PrivateEndpointConnectionItem]
    :ivar public_network_access: Property to specify whether the vault will accept traffic from
     public internet. If set to 'disabled' all traffic except private endpoint traffic and that that
     originates from trusted services will be blocked. This will override the set firewall rules,
     meaning that even if the firewall rules are present we will not honor the rules.
    :vartype public_network_access: str
    """

    tenant_id: str = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the key
     vault. Required."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details. Required."""
    access_policies: Optional[list["_models.AccessPolicyEntry"]] = rest_field(
        name="accessPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of 0 to 1024 identities that have access to the key vault. All identities in the array
     must use the same tenant ID as the key vault's tenant ID. When ``createMode`` is set to
     ``recover``, access policies are not required. Otherwise, access policies are required."""
    vault_uri: Optional[str] = rest_field(name="vaultUri", visibility=["read", "create", "update", "delete", "query"])
    """The URI of the vault for performing operations on keys and secrets."""
    hsm_pool_resource_id: Optional[str] = rest_field(name="hsmPoolResourceId", visibility=["read"])
    """The resource id of HSM Pool."""
    enabled_for_deployment: Optional[bool] = rest_field(
        name="enabledForDeployment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Virtual Machines are permitted to retrieve certificates
     stored as secrets from the key vault."""
    enabled_for_disk_encryption: Optional[bool] = rest_field(
        name="enabledForDiskEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the
     vault and unwrap keys."""
    enabled_for_template_deployment: Optional[bool] = rest_field(
        name="enabledForTemplateDeployment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the
     key vault."""
    enable_soft_delete: Optional[bool] = rest_field(
        name="enableSoftDelete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the 'soft delete' functionality is enabled for this key vault. If
     it's not set to any value(true or false) when creating new key vault, it will be set to true by
     default. Once set to true, it cannot be reverted to false."""
    soft_delete_retention_in_days: Optional[int] = rest_field(
        name="softDeleteRetentionInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """softDelete data retention days. It accepts >=7 and <=90."""
    enable_rbac_authorization: Optional[bool] = rest_field(
        name="enableRbacAuthorization", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property that controls how data actions are authorized. When true, the key vault will use Role
     Based Access Control (RBAC) for authorization of data actions, and the access policies
     specified in vault properties will be  ignored. When false, the key vault will use the access
     policies specified in vault properties, and any policy stored on Azure Resource Manager will be
     ignored. If null or not specified, the vault is created with the default value of false. Note
     that management actions are always authorized with RBAC."""
    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(
        name="createMode", visibility=["create", "update"]
    )
    """The vault's create mode to indicate whether the vault need to be recovered or not. Known values
     are: \"recover\" and \"default\"."""
    enable_purge_protection: Optional[bool] = rest_field(
        name="enablePurgeProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying whether protection against purge is enabled for this vault. Setting this
     property to true activates protection against purge for this vault and its content - only the
     Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if
     soft delete is also enabled. Enabling this functionality is irreversible - that is, the
     property does not accept false as its value."""
    network_acls: Optional["_models.NetworkRuleSet"] = rest_field(
        name="networkAcls", visibility=["read", "create", "update", "delete", "query"]
    )
    """Rules governing the accessibility of the key vault from specific network locations."""
    provisioning_state: Optional[Union[str, "_models.VaultProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provisioning state of the vault. Known values are: \"Succeeded\" and \"RegisteringDns\"."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnectionItem"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections associated with the key vault."""
    public_network_access: Optional[str] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether the vault will accept traffic from public internet. If set to
     'disabled' all traffic except private endpoint traffic and that that originates from trusted
     services will be blocked. This will override the set firewall rules, meaning that even if the
     firewall rules are present we will not honor the rules."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: str,
        sku: "_models.Sku",
        access_policies: Optional[list["_models.AccessPolicyEntry"]] = None,
        vault_uri: Optional[str] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        enable_rbac_authorization: Optional[bool] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        provisioning_state: Optional[Union[str, "_models.VaultProvisioningState"]] = None,
        public_network_access: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkRule(_Model):
    """A rule governing the accessibility of a vault from a specific virtual network.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    :ivar ignore_missing_vnet_service_endpoint: Property to specify whether NRP will ignore the
     check if parent subnet has serviceEndpoints configured.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required."""
    ignore_missing_vnet_service_endpoint: Optional[bool] = rest_field(
        name="ignoreMissingVnetServiceEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints
     configured."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
