//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/support/armsupport/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TicketChatTranscriptsNoSubscriptionServer is a fake server for instances of the armsupport.TicketChatTranscriptsNoSubscriptionClient type.
type TicketChatTranscriptsNoSubscriptionServer struct {
	// NewListPager is the fake for method TicketChatTranscriptsNoSubscriptionClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(supportTicketName string, options *armsupport.TicketChatTranscriptsNoSubscriptionClientListOptions) (resp azfake.PagerResponder[armsupport.TicketChatTranscriptsNoSubscriptionClientListResponse])
}

// NewTicketChatTranscriptsNoSubscriptionServerTransport creates a new instance of TicketChatTranscriptsNoSubscriptionServerTransport with the provided implementation.
// The returned TicketChatTranscriptsNoSubscriptionServerTransport instance is connected to an instance of armsupport.TicketChatTranscriptsNoSubscriptionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTicketChatTranscriptsNoSubscriptionServerTransport(srv *TicketChatTranscriptsNoSubscriptionServer) *TicketChatTranscriptsNoSubscriptionServerTransport {
	return &TicketChatTranscriptsNoSubscriptionServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsupport.TicketChatTranscriptsNoSubscriptionClientListResponse]](),
	}
}

// TicketChatTranscriptsNoSubscriptionServerTransport connects instances of armsupport.TicketChatTranscriptsNoSubscriptionClient to instances of TicketChatTranscriptsNoSubscriptionServer.
// Don't use this type directly, use NewTicketChatTranscriptsNoSubscriptionServerTransport instead.
type TicketChatTranscriptsNoSubscriptionServerTransport struct {
	srv          *TicketChatTranscriptsNoSubscriptionServer
	newListPager *tracker[azfake.PagerResponder[armsupport.TicketChatTranscriptsNoSubscriptionClientListResponse]]
}

// Do implements the policy.Transporter interface for TicketChatTranscriptsNoSubscriptionServerTransport.
func (t *TicketChatTranscriptsNoSubscriptionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TicketChatTranscriptsNoSubscriptionClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TicketChatTranscriptsNoSubscriptionServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Support/supportTickets/(?P<supportTicketName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/chatTranscripts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		supportTicketNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("supportTicketName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListPager(supportTicketNameParam, nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsupport.TicketChatTranscriptsNoSubscriptionClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}
