//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbiembedded

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// ManagementClient contains the methods for the PowerBIEmbeddedManagementClient group.
// Don't use this type directly, use NewManagementClient() instead.
type ManagementClient struct {
	internal *arm.Client
}

// NewManagementClient creates a new instance of ManagementClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagementClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementClient{
		internal: cl,
	}
	return client, nil
}

// GetAvailableOperations - Indicates which operations can be performed by the Power BI Resource Provider.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-01-29
//   - options - ManagementClientGetAvailableOperationsOptions contains the optional parameters for the ManagementClient.GetAvailableOperations
//     method.
func (client *ManagementClient) GetAvailableOperations(ctx context.Context, options *ManagementClientGetAvailableOperationsOptions) (ManagementClientGetAvailableOperationsResponse, error) {
	var err error
	const operationName = "ManagementClient.GetAvailableOperations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAvailableOperationsCreateRequest(ctx, options)
	if err != nil {
		return ManagementClientGetAvailableOperationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementClientGetAvailableOperationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementClientGetAvailableOperationsResponse{}, err
	}
	resp, err := client.getAvailableOperationsHandleResponse(httpResp)
	return resp, err
}

// getAvailableOperationsCreateRequest creates the GetAvailableOperations request.
func (client *ManagementClient) getAvailableOperationsCreateRequest(ctx context.Context, options *ManagementClientGetAvailableOperationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.PowerBI/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-01-29")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAvailableOperationsHandleResponse handles the GetAvailableOperations response.
func (client *ManagementClient) getAvailableOperationsHandleResponse(resp *http.Response) (ManagementClientGetAvailableOperationsResponse, error) {
	result := ManagementClientGetAvailableOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationList); err != nil {
		return ManagementClientGetAvailableOperationsResponse{}, err
	}
	return result, nil
}
