//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetwork/armmanagednetwork"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// GroupsServer is a fake server for instances of the armmanagednetwork.GroupsClient type.
type GroupsServer struct {
	// BeginCreateOrUpdate is the fake for method GroupsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkGroupName string, managedNetworkGroup armmanagednetwork.Group, options *armmanagednetwork.GroupsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmanagednetwork.GroupsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method GroupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkGroupName string, options *armmanagednetwork.GroupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetwork.GroupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method GroupsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedNetworkName string, managedNetworkGroupName string, options *armmanagednetwork.GroupsClientGetOptions) (resp azfake.Responder[armmanagednetwork.GroupsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedNetworkPager is the fake for method GroupsClient.NewListByManagedNetworkPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedNetworkPager func(resourceGroupName string, managedNetworkName string, options *armmanagednetwork.GroupsClientListByManagedNetworkOptions) (resp azfake.PagerResponder[armmanagednetwork.GroupsClientListByManagedNetworkResponse])
}

// NewGroupsServerTransport creates a new instance of GroupsServerTransport with the provided implementation.
// The returned GroupsServerTransport instance is connected to an instance of armmanagednetwork.GroupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGroupsServerTransport(srv *GroupsServer) *GroupsServerTransport {
	return &GroupsServerTransport{
		srv:                          srv,
		beginCreateOrUpdate:          newTracker[azfake.PollerResponder[armmanagednetwork.GroupsClientCreateOrUpdateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armmanagednetwork.GroupsClientDeleteResponse]](),
		newListByManagedNetworkPager: newTracker[azfake.PagerResponder[armmanagednetwork.GroupsClientListByManagedNetworkResponse]](),
	}
}

// GroupsServerTransport connects instances of armmanagednetwork.GroupsClient to instances of GroupsServer.
// Don't use this type directly, use NewGroupsServerTransport instead.
type GroupsServerTransport struct {
	srv                          *GroupsServer
	beginCreateOrUpdate          *tracker[azfake.PollerResponder[armmanagednetwork.GroupsClientCreateOrUpdateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armmanagednetwork.GroupsClientDeleteResponse]]
	newListByManagedNetworkPager *tracker[azfake.PagerResponder[armmanagednetwork.GroupsClientListByManagedNetworkResponse]]
}

// Do implements the policy.Transporter interface for GroupsServerTransport.
func (g *GroupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GroupsClient.BeginCreateOrUpdate":
		resp, err = g.dispatchBeginCreateOrUpdate(req)
	case "GroupsClient.BeginDelete":
		resp, err = g.dispatchBeginDelete(req)
	case "GroupsClient.Get":
		resp, err = g.dispatchGet(req)
	case "GroupsClient.NewListByManagedNetworkPager":
		resp, err = g.dispatchNewListByManagedNetworkPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GroupsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := g.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkGroups/(?P<managedNetworkGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetwork.Group](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		managedNetworkGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		g.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		g.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		g.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (g *GroupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if g.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := g.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkGroups/(?P<managedNetworkGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		managedNetworkGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginDelete(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		g.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		g.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		g.beginDelete.remove(req)
	}

	return resp, nil
}

func (g *GroupsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkGroups/(?P<managedNetworkGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
	if err != nil {
		return nil, err
	}
	managedNetworkGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), resourceGroupNameParam, managedNetworkNameParam, managedNetworkGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Group, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GroupsServerTransport) dispatchNewListByManagedNetworkPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListByManagedNetworkPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedNetworkPager not implemented")}
	}
	newListByManagedNetworkPager := g.newListByManagedNetworkPager.get(req)
	if newListByManagedNetworkPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetwork/managedNetworks/(?P<managedNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managedNetworkGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedNetworkName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armmanagednetwork.GroupsClientListByManagedNetworkOptions
		if topParam != nil || skiptokenParam != nil {
			options = &armmanagednetwork.GroupsClientListByManagedNetworkOptions{
				Top:       topParam,
				Skiptoken: skiptokenParam,
			}
		}
		resp := g.srv.NewListByManagedNetworkPager(resourceGroupNameParam, managedNetworkNameParam, options)
		newListByManagedNetworkPager = &resp
		g.newListByManagedNetworkPager.add(req, newListByManagedNetworkPager)
		server.PagerResponderInjectNextLinks(newListByManagedNetworkPager, req, func(page *armmanagednetwork.GroupsClientListByManagedNetworkResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedNetworkPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListByManagedNetworkPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedNetworkPager) {
		g.newListByManagedNetworkPager.remove(req)
	}
	return resp, nil
}
