//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/maintenance/armmaintenance"
	"net/http"
	"net/url"
	"regexp"
)

// ApplyUpdateForResourceGroupServer is a fake server for instances of the armmaintenance.ApplyUpdateForResourceGroupClient type.
type ApplyUpdateForResourceGroupServer struct {
	// NewListPager is the fake for method ApplyUpdateForResourceGroupClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armmaintenance.ApplyUpdateForResourceGroupClientListOptions) (resp azfake.PagerResponder[armmaintenance.ApplyUpdateForResourceGroupClientListResponse])
}

// NewApplyUpdateForResourceGroupServerTransport creates a new instance of ApplyUpdateForResourceGroupServerTransport with the provided implementation.
// The returned ApplyUpdateForResourceGroupServerTransport instance is connected to an instance of armmaintenance.ApplyUpdateForResourceGroupClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewApplyUpdateForResourceGroupServerTransport(srv *ApplyUpdateForResourceGroupServer) *ApplyUpdateForResourceGroupServerTransport {
	return &ApplyUpdateForResourceGroupServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmaintenance.ApplyUpdateForResourceGroupClientListResponse]](),
	}
}

// ApplyUpdateForResourceGroupServerTransport connects instances of armmaintenance.ApplyUpdateForResourceGroupClient to instances of ApplyUpdateForResourceGroupServer.
// Don't use this type directly, use NewApplyUpdateForResourceGroupServerTransport instead.
type ApplyUpdateForResourceGroupServerTransport struct {
	srv          *ApplyUpdateForResourceGroupServer
	newListPager *tracker[azfake.PagerResponder[armmaintenance.ApplyUpdateForResourceGroupClientListResponse]]
}

// Do implements the policy.Transporter interface for ApplyUpdateForResourceGroupServerTransport.
func (a *ApplyUpdateForResourceGroupServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ApplyUpdateForResourceGroupClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ApplyUpdateForResourceGroupServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
