//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdnsresolver

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewDNSForwardingRulesetsClient creates a new instance of DNSForwardingRulesetsClient.
func (c *ClientFactory) NewDNSForwardingRulesetsClient() *DNSForwardingRulesetsClient {
	subClient, _ := NewDNSForwardingRulesetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDNSResolversClient creates a new instance of DNSResolversClient.
func (c *ClientFactory) NewDNSResolversClient() *DNSResolversClient {
	subClient, _ := NewDNSResolversClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewForwardingRulesClient creates a new instance of ForwardingRulesClient.
func (c *ClientFactory) NewForwardingRulesClient() *ForwardingRulesClient {
	subClient, _ := NewForwardingRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewInboundEndpointsClient creates a new instance of InboundEndpointsClient.
func (c *ClientFactory) NewInboundEndpointsClient() *InboundEndpointsClient {
	subClient, _ := NewInboundEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOutboundEndpointsClient creates a new instance of OutboundEndpointsClient.
func (c *ClientFactory) NewOutboundEndpointsClient() *OutboundEndpointsClient {
	subClient, _ := NewOutboundEndpointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworkLinksClient creates a new instance of VirtualNetworkLinksClient.
func (c *ClientFactory) NewVirtualNetworkLinksClient() *VirtualNetworkLinksClient {
	subClient, _ := NewVirtualNetworkLinksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
