//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ControllerClient contains the methods for the Controller group.
// Don't use this type directly, use NewControllerClient() instead.
type ControllerClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewControllerClient creates a new instance of ControllerClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewControllerClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ControllerClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ControllerClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Create a dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - controller type parameters
//   - options - ControllerClientBeginCreateOptions contains the optional parameters for the ControllerClient.BeginCreate method.
func (client *ControllerClient) BeginCreate(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*runtime.Poller[ControllerClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ControllerClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ControllerClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create a dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *ControllerClient) create(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "ControllerClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *ControllerClient) createCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the DNC controller
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - ControllerClientBeginDeleteOptions contains the optional parameters for the ControllerClient.BeginDelete method.
func (client *ControllerClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*runtime.Poller[ControllerClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ControllerClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ControllerClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the DNC controller
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
func (client *ControllerClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "ControllerClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ControllerClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the specified dnc controller.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - options - ControllerClientGetDetailsOptions contains the optional parameters for the ControllerClient.GetDetails method.
func (client *ControllerClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientGetDetailsOptions) (ControllerClientGetDetailsResponse, error) {
	var err error
	const operationName = "ControllerClient.GetDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ControllerClientGetDetailsResponse{}, err
	}
	resp, err := client.getDetailsHandleResponse(httpResp)
	return resp, err
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *ControllerClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *ControllerClient) getDetailsHandleResponse(resp *http.Response) (ControllerClientGetDetailsResponse, error) {
	result := ControllerClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedController); err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	return result, nil
}

// Patch - Update dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-03-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
//   - parameters - controller type parameters
//   - options - ControllerClientPatchOptions contains the optional parameters for the ControllerClient.Patch method.
func (client *ControllerClient) Patch(ctx context.Context, resourceGroupName string, resourceName string, parameters ControllerResourceUpdateParameters, options *ControllerClientPatchOptions) (ControllerClientPatchResponse, error) {
	var err error
	const operationName = "ControllerClient.Patch"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ControllerClientPatchResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ControllerClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ControllerClientPatchResponse{}, err
	}
	resp, err := client.patchHandleResponse(httpResp)
	return resp, err
}

// patchCreateRequest creates the Patch request.
func (client *ControllerClient) patchCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ControllerResourceUpdateParameters, options *ControllerClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// patchHandleResponse handles the Patch response.
func (client *ControllerClient) patchHandleResponse(resp *http.Response) (ControllerClientPatchResponse, error) {
	result := ControllerClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedController); err != nil {
		return ControllerClientPatchResponse{}, err
	}
	return result, nil
}
