//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcognitiveservices

import "time"

// APIKeys - The access keys for the cognitive services account.
type APIKeys struct {
	// Gets the value of key 1.
	Key1 *string

	// Gets the value of key 2.
	Key2 *string
}

// APIProperties - The api properties for special APIs.
type APIProperties struct {
	// (Metrics Advisor Only) The Azure AD Client Id (Application Id).
	AADClientID *string

	// (Metrics Advisor Only) The Azure AD Tenant Id.
	AADTenantID *string

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// (Personalization Only) The flag to enable statistics of Bing Search.
	EventHubConnectionString *string

	// (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
	QnaAzureSearchEndpointID *string

	// (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
	QnaAzureSearchEndpointKey *string

	// (QnAMaker Only) The runtime endpoint of QnAMaker.
	QnaRuntimeEndpoint *string

	// (Bing Search Only) The flag to enable statistics of Bing Search.
	StatisticsEnabled *bool

	// (Personalization Only) The storage account connection string.
	StorageAccountConnectionString *string

	// (Metrics Advisor Only) The super user of Metrics Advisor.
	SuperUser *string

	// (Metrics Advisor Only) The website name of Metrics Advisor.
	WebsiteName *string
}

// AbusePenalty - The abuse penalty.
type AbusePenalty struct {
	// The action of AbusePenalty.
	Action *AbusePenaltyAction

	// The datetime of expiration of the AbusePenalty.
	Expiration *time.Time

	// The percentage of rate limit.
	RateLimitPercentage *float32
}

// Account - Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and
// SKU.
type Account struct {
	// Identity for the resource.
	Identity *Identity

	// The Kind of the resource.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// Properties of Cognitive Services account.
	Properties *AccountProperties

	// The resource model definition representing SKU
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccountListResult - The list of cognitive services accounts operation response.
type AccountListResult struct {
	// The link used to get the next page of accounts.
	NextLink *string

	// READ-ONLY; Gets the list of Cognitive Services accounts and their properties.
	Value []*Account
}

// AccountModel - Cognitive Services account Model.
type AccountModel struct {
	// Base Model Identifier.
	BaseModel *DeploymentModel

	// The capabilities.
	Capabilities map[string]*string

	// Cognitive Services account ModelDeprecationInfo.
	Deprecation *ModelDeprecationInfo

	// The capabilities for finetune models.
	FinetuneCapabilities map[string]*string

	// Deployment model format.
	Format *string

	// If the model is default version.
	IsDefaultVersion *bool

	// Model lifecycle status.
	LifecycleStatus *ModelLifecycleStatus

	// The max capacity.
	MaxCapacity *int32

	// Deployment model name.
	Name *string

	// The list of Model Sku.
	SKUs []*ModelSKU

	// Optional. Deployment model source ARM resource ID.
	Source *string

	// Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version
	// is different for different models and might change when there is new version
	// available for a model. Default version for a model could be found from list models API.
	Version *string

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData
}

// AccountModelListResult - The list of cognitive services accounts operation response.
type AccountModelListResult struct {
	// The link used to get the next page of Model.
	NextLink *string

	// Gets the list of Cognitive Services accounts Model and their properties.
	Value []*AccountModel
}

// AccountProperties - Properties of Cognitive Services account.
type AccountProperties struct {
	// The api properties for special APIs.
	APIProperties   *APIProperties
	AllowedFqdnList []*string

	// Optional subdomain name used for token-based authentication.
	CustomSubDomainName *string
	DisableLocalAuth    *bool

	// The flag to enable dynamic throttling.
	DynamicThrottlingEnabled *bool

	// The encryption properties for this resource.
	Encryption *Encryption

	// The multiregion settings of Cognitive Services account.
	Locations *MultiRegionSettings

	// Resource migration token.
	MigrationToken *string

	// A collection of rules governing the accessibility from specific network locations.
	NetworkACLs *NetworkRuleSet

	// Whether or not public endpoint access is allowed for this account.
	PublicNetworkAccess           *PublicNetworkAccess
	Restore                       *bool
	RestrictOutboundNetworkAccess *bool

	// The storage accounts for this resource.
	UserOwnedStorage []*UserOwnedStorage

	// READ-ONLY; The abuse penalty.
	AbusePenalty *AbusePenalty

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit

	// READ-ONLY; Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature.
	// The values are read-only and for reference only.
	Capabilities []*SKUCapability

	// READ-ONLY; The commitment plan associations of Cognitive Services account.
	CommitmentPlanAssociations []*CommitmentPlanAssociation

	// READ-ONLY; Gets the date of cognitive services account creation.
	DateCreated *string

	// READ-ONLY; The deletion date, only available for deleted account.
	DeletionDate *string

	// READ-ONLY; Endpoint of the created account.
	Endpoint *string

	// READ-ONLY; Dictionary of
	Endpoints map[string]*string

	// READ-ONLY; The internal identifier (deprecated, do not use this property).
	InternalID *string

	// READ-ONLY; If the resource is migrated from an existing key.
	IsMigrated *bool

	// READ-ONLY; The private endpoint connection associated with the Cognitive Services account.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Gets the status of the cognitive services account at the time the operation was called.
	ProvisioningState *ProvisioningState

	// READ-ONLY
	QuotaLimit *QuotaLimit

	// READ-ONLY; Sku change info of account.
	SKUChangeInfo *SKUChangeInfo

	// READ-ONLY; The scheduled purge date, only available for deleted account.
	ScheduledPurgeDate *string
}

// AccountSKU - Cognitive Services resource type and SKU.
type AccountSKU struct {
	// Resource Namespace and Type
	ResourceType *string

	// The SKU of Cognitive Services account.
	SKU *SKU
}

// AccountSKUListResult - The list of cognitive services accounts operation response.
type AccountSKUListResult struct {
	// Gets the list of Cognitive Services accounts and their properties.
	Value []*AccountSKU
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CallRateLimit - The call rate limit Cognitive Services account.
type CallRateLimit struct {
	// The count value of Call Rate Limit.
	Count *float32

	// The renewal period in seconds of Call Rate Limit.
	RenewalPeriod *float32
	Rules         []*ThrottlingRule
}

// CapacityConfig - The capacity configuration.
type CapacityConfig struct {
	// The default capacity.
	Default *int32

	// The maximum capacity.
	Maximum *int32

	// The minimum capacity.
	Minimum *int32

	// The minimal incremental between allowed values for capacity.
	Step *int32
}

// CheckDomainAvailabilityParameter - Check Domain availability parameter.
type CheckDomainAvailabilityParameter struct {
	// REQUIRED; The subdomain name to use.
	SubdomainName *string

	// REQUIRED; The Type of the resource.
	Type *string

	// The Kind of the resource.
	Kind *string
}

// CheckSKUAvailabilityParameter - Check SKU availability parameter.
type CheckSKUAvailabilityParameter struct {
	// REQUIRED; The Kind of the resource.
	Kind *string

	// REQUIRED; The SKU of the resource.
	SKUs []*string

	// REQUIRED; The Type of the resource.
	Type *string
}

// CommitmentCost - Cognitive Services account commitment cost.
type CommitmentCost struct {
	// Commitment meter Id.
	CommitmentMeterID *string

	// Overage meter Id.
	OverageMeterID *string
}

// CommitmentPeriod - Cognitive Services account commitment period.
type CommitmentPeriod struct {
	// Commitment period commitment count.
	Count *int32

	// Commitment period commitment tier.
	Tier *string

	// READ-ONLY; Commitment period end date.
	EndDate *string

	// READ-ONLY; Cognitive Services account commitment quota.
	Quota *CommitmentQuota

	// READ-ONLY; Commitment period start date.
	StartDate *string
}

// CommitmentPlan - Cognitive Services account commitment plan.
type CommitmentPlan struct {
	// The Kind of the resource.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// Properties of Cognitive Services account commitment plan.
	Properties *CommitmentPlanProperties

	// The resource model definition representing SKU
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CommitmentPlanAccountAssociation - The commitment plan association.
type CommitmentPlanAccountAssociation struct {
	// Properties of Cognitive Services account commitment plan association.
	Properties *CommitmentPlanAccountAssociationProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CommitmentPlanAccountAssociationListResult - The list of cognitive services Commitment Plan Account Association operation
// response.
type CommitmentPlanAccountAssociationListResult struct {
	// The link used to get the next page of Commitment Plan Account Association.
	NextLink *string

	// READ-ONLY; Gets the list of Cognitive Services Commitment Plan Account Association and their properties.
	Value []*CommitmentPlanAccountAssociation
}

// CommitmentPlanAccountAssociationProperties - The commitment plan account association properties.
type CommitmentPlanAccountAssociationProperties struct {
	// The Azure resource id of the account.
	AccountID *string
}

// CommitmentPlanAssociation - The commitment plan association.
type CommitmentPlanAssociation struct {
	// The Azure resource id of the commitment plan.
	CommitmentPlanID *string

	// The location of of the commitment plan.
	CommitmentPlanLocation *string
}

// CommitmentPlanListResult - The list of cognitive services accounts operation response.
type CommitmentPlanListResult struct {
	// The link used to get the next page of CommitmentPlan.
	NextLink *string

	// READ-ONLY; Gets the list of Cognitive Services accounts CommitmentPlan and their properties.
	Value []*CommitmentPlan
}

// CommitmentPlanProperties - Properties of Cognitive Services account commitment plan.
type CommitmentPlanProperties struct {
	// AutoRenew commitment plan.
	AutoRenew *bool

	// Commitment plan guid.
	CommitmentPlanGUID *string

	// Cognitive Services account commitment period.
	Current *CommitmentPeriod

	// Account hosting model.
	HostingModel *HostingModel

	// Cognitive Services account commitment period.
	Next *CommitmentPeriod

	// Commitment plan type.
	PlanType *string

	// READ-ONLY; Cognitive Services account commitment period.
	Last *CommitmentPeriod

	// READ-ONLY; The list of ProvisioningIssue.
	ProvisioningIssues []*string

	// READ-ONLY; Gets the status of the resource at the time the operation was called.
	ProvisioningState *CommitmentPlanProvisioningState
}

// CommitmentQuota - Cognitive Services account commitment quota.
type CommitmentQuota struct {
	// Commitment quota quantity.
	Quantity *int64

	// Commitment quota unit.
	Unit *string
}

// CommitmentTier - Cognitive Services account commitment tier.
type CommitmentTier struct {
	// Cognitive Services account commitment cost.
	Cost *CommitmentCost

	// Account hosting model.
	HostingModel *HostingModel

	// The Kind of the resource.
	Kind *string

	// Commitment period commitment max count.
	MaxCount *int32

	// Commitment plan type.
	PlanType *string

	// Cognitive Services account commitment quota.
	Quota *CommitmentQuota

	// The name of the SKU. Ex - P3. It is typically a letter+number code
	SKUName *string

	// Commitment period commitment tier.
	Tier *string
}

// CommitmentTierListResult - The list of cognitive services accounts operation response.
type CommitmentTierListResult struct {
	// The link used to get the next page of CommitmentTier.
	NextLink *string

	// READ-ONLY; Gets the list of Cognitive Services accounts CommitmentTier and their properties.
	Value []*CommitmentTier
}

// Deployment - Cognitive Services account deployment.
type Deployment struct {
	// Properties of Cognitive Services account deployment.
	Properties *DeploymentProperties

	// The resource model definition representing SKU
	SKU *SKU

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DeploymentListResult - The list of cognitive services accounts operation response.
type DeploymentListResult struct {
	// The link used to get the next page of Deployment.
	NextLink *string

	// READ-ONLY; Gets the list of Cognitive Services accounts Deployment and their properties.
	Value []*Deployment
}

// DeploymentModel - Properties of Cognitive Services account deployment model.
type DeploymentModel struct {
	// Deployment model format.
	Format *string

	// Deployment model name.
	Name *string

	// Optional. Deployment model source ARM resource ID.
	Source *string

	// Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version
	// is different for different models and might change when there is new version
	// available for a model. Default version for a model could be found from list models API.
	Version *string

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit
}

// DeploymentProperties - Properties of Cognitive Services account deployment.
type DeploymentProperties struct {
	// Properties of Cognitive Services account deployment model.
	Model *DeploymentModel

	// The name of RAI policy.
	RaiPolicyName *string

	// Properties of Cognitive Services account deployment model.
	ScaleSettings *DeploymentScaleSettings

	// Deployment model version upgrade option.
	VersionUpgradeOption *DeploymentModelVersionUpgradeOption

	// READ-ONLY; The call rate limit Cognitive Services account.
	CallRateLimit *CallRateLimit

	// READ-ONLY; The capabilities.
	Capabilities map[string]*string

	// READ-ONLY; Gets the status of the resource at the time the operation was called.
	ProvisioningState *DeploymentProvisioningState

	// READ-ONLY
	RateLimits []*ThrottlingRule
}

// DeploymentScaleSettings - Properties of Cognitive Services account deployment model.
type DeploymentScaleSettings struct {
	// Deployment capacity.
	Capacity *int32

	// Deployment scale type.
	ScaleType *DeploymentScaleType

	// READ-ONLY; Deployment active capacity. This value might be different from capacity if customer recently updated capacity.
	ActiveCapacity *int32
}

// DomainAvailability - Domain availability.
type DomainAvailability struct {
	// Indicates the given SKU is available or not.
	IsSubdomainAvailable *bool

	// The Kind of the resource.
	Kind *string

	// Reason why the SKU is not available.
	Reason *string

	// The subdomain name to use.
	SubdomainName *string

	// The Type of the resource.
	Type *string
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *KeySource

	// Properties of KeyVault
	KeyVaultProperties *KeyVaultProperties
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// IPRule - A rule governing the accessibility from a specific ip address or ip range.
type IPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	IdentityClientID *string

	// Name of the Key from KeyVault
	KeyName *string

	// Uri of KeyVault
	KeyVaultURI *string

	// Version of the Key from KeyVault
	KeyVersion *string
}

// MetricName - A metric name.
type MetricName struct {
	// The friendly name of the metric.
	LocalizedValue *string

	// The name of the metric.
	Value *string
}

// Model - Cognitive Services Model.
type Model struct {
	// The Kind of the Model.
	Kind *string

	// Model Metadata.
	Model *AccountModel

	// The SKU of the Model.
	SKUName *string
}

// ModelDeprecationInfo - Cognitive Services account ModelDeprecationInfo.
type ModelDeprecationInfo struct {
	// The datetime of deprecation of the fineTune Model.
	FineTune *string

	// The datetime of deprecation of the inference Model.
	Inference *string
}

// ModelListResult - The list of cognitive services models.
type ModelListResult struct {
	// The link used to get the next page of Model.
	NextLink *string

	// Gets the list of Cognitive Services accounts Model and their properties.
	Value []*Model
}

// ModelSKU - Describes an available Cognitive Services Model SKU.
type ModelSKU struct {
	// The capacity configuration.
	Capacity *CapacityConfig

	// The datetime of deprecation of the model SKU.
	DeprecationDate *time.Time

	// The name of the model SKU.
	Name *string

	// The list of rateLimit.
	RateLimits []*CallRateLimit

	// The usage name of the model SKU.
	UsageName *string
}

// MultiRegionSettings - The multiregion settings Cognitive Services account.
type MultiRegionSettings struct {
	Regions []*RegionSetting

	// Multiregion routing methods.
	RoutingMethod *RoutingMethods
}

// NetworkRuleSet - A set of rules governing the network accessibility.
type NetworkRuleSet struct {
	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction

	// The list of IP address rules.
	IPRules []*IPRule

	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// PatchResourceTags - The object being used to update tags of a resource, in general used for PATCH operations.
type PatchResourceTags struct {
	// Resource tags.
	Tags map[string]*string
}

// PatchResourceTagsAndSKU - The object being used to update tags and sku of a resource, in general used for PATCH operations.
type PatchResourceTagsAndSKU struct {
	// The resource model definition representing SKU
	SKU *SKU

	// Resource tags.
	Tags map[string]*string
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// The location of the private endpoint connection
	Location *string

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The private link resource group ids.
	GroupIDs []*string

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource display name.
	DisplayName *string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type QuotaLimit struct {
	Count         *float32
	RenewalPeriod *float32
	Rules         []*ThrottlingRule
}

// RegenerateKeyParameters - Regenerate key parameters.
type RegenerateKeyParameters struct {
	// REQUIRED; key name to generate (Key1|Key2)
	KeyName *KeyName
}

// RegionSetting - The call rate limit Cognitive Services account.
type RegionSetting struct {
	// Maps the region to the regional custom subdomain.
	Customsubdomain *string

	// Name of the region.
	Name *string

	// A value for priority or weighted routing methods.
	Value *float32
}

type RequestMatchPattern struct {
	Method *string
	Path   *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceSKU - Describes an available Cognitive Services SKU.
type ResourceSKU struct {
	// The Kind of resources that are supported in this SKU.
	Kind *string

	// The set of locations that the SKU is available.
	Locations []*string

	// The name of SKU.
	Name *string

	// The type of resource the SKU applies to.
	ResourceType *string

	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions

	// Specifies the tier of Cognitive Services account.
	Tier *string
}

// ResourceSKUListResult - The Get Skus operation response.
type ResourceSKUListResult struct {
	// REQUIRED; The list of skus available for the subscription.
	Value []*ResourceSKU

	// The uri to fetch the next page of Skus.
	NextLink *string
}

type ResourceSKURestrictionInfo struct {
	// Locations where the SKU is restricted
	Locations []*string

	// List of availability zones where the SKU is restricted.
	Zones []*string
}

// ResourceSKURestrictions - Describes restrictions of a SKU.
type ResourceSKURestrictions struct {
	// The reason for restriction.
	ReasonCode *ResourceSKURestrictionsReasonCode

	// The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSKURestrictionInfo

	// The type of restrictions.
	Type *ResourceSKURestrictionsType

	// The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU
	// is restricted.
	Values []*string
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SKUAvailability - SKU availability.
type SKUAvailability struct {
	// The Kind of the resource.
	Kind *string

	// Additional error message.
	Message *string

	// Reason why the SKU is not available.
	Reason *string

	// Indicates the given SKU is available or not.
	SKUAvailable *bool

	// The SKU of Cognitive Services account.
	SKUName *string

	// The Type of the resource.
	Type *string
}

// SKUAvailabilityListResult - Check SKU availability result list.
type SKUAvailabilityListResult struct {
	// Check SKU availability result list.
	Value []*SKUAvailability
}

// SKUCapability - SkuCapability indicates the capability of a certain feature.
type SKUCapability struct {
	// The name of the SkuCapability.
	Name *string

	// The value of the SkuCapability.
	Value *string
}

// SKUChangeInfo - Sku change info of account.
type SKUChangeInfo struct {
	// Gets the count of downgrades.
	CountOfDowngrades *float32

	// Gets the count of upgrades after downgrades.
	CountOfUpgradesAfterDowngrades *float32

	// Gets the last change date.
	LastChangeDate *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

type ThrottlingRule struct {
	Count                    *float32
	DynamicThrottlingEnabled *bool
	Key                      *string
	MatchPatterns            []*RequestMatchPattern
	MinCount                 *float32
	RenewalPeriod            *float32
}

// Usage - The usage data for a usage request.
type Usage struct {
	// Current value for this metric.
	CurrentValue *float64

	// Maximum value for this metric.
	Limit *float64

	// The name information for the metric.
	Name *MetricName

	// Next reset time for current quota.
	NextResetTime *string

	// The quota period used to summarize the usage values.
	QuotaPeriod *string

	// Cognitive Services account quota usage status.
	Status *QuotaUsageStatus

	// The unit of the metric.
	Unit *UnitType
}

// UsageListResult - The response to a list usage request.
type UsageListResult struct {
	// The link used to get the next page of Usages.
	NextLink *string

	// The list of usages for Cognitive Service account.
	Value []*Usage
}

// UserAssignedIdentity - User-assigned managed identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client App Id associated with this identity.
	ClientID *string

	// READ-ONLY; Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string
}

// UserOwnedStorage - The user owned storage for Cognitive Services account.
type UserOwnedStorage struct {
	IdentityClientID *string

	// Full resource id of a Microsoft.Storage resource.
	ResourceID *string
}

// VirtualNetworkRule - A rule governing the accessibility from a specific virtual network.
type VirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string

	// Ignore missing vnet service endpoint or not.
	IgnoreMissingVnetServiceEndpoint *bool

	// Gets the state of virtual network rule.
	State *string
}
